package com.groupbyinc.common.util.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.Thread.UncaughtExceptionHandler;

/**
 * Default {@link UncaughtExceptionHandler)
 */
public class DefaultUncaughtExceptionHandler implements UncaughtExceptionHandler {

    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        LOG.error("Encountered uncaught exception [" + throwable.getClass().getSimpleName() + "] in thread [" + thread.getName() + "]: " + throwable.getMessage(), throwable);
    }

}
