/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.directbeacon;

import com.groupbyinc.common.apache.http.HttpEntity;
import com.groupbyinc.common.apache.http.HttpResponse;
import com.groupbyinc.common.apache.http.StatusLine;
import com.groupbyinc.common.apache.http.client.HttpClient;
import com.groupbyinc.common.apache.http.client.methods.HttpPost;
import com.groupbyinc.common.apache.http.entity.StringEntity;
import com.groupbyinc.common.apache.http.util.EntityUtils;
import com.groupbyinc.common.directbeacon.DirectBeacon;
import com.groupbyinc.common.jackson.Mappers;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBeaconClientTask<T>
implements Runnable {
    private static final transient Logger LOG = LoggerFactory.getLogger(DirectBeaconClientTask.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String APPLICATION_JSON = "application/json";
    private final URI uri;
    private final HttpClient httpClient;
    private final String authToken;
    private DirectBeacon<T> beacon;

    public DirectBeaconClientTask(HttpClient httpClient, URI uri, DirectBeacon<T> beacon, String authToken) {
        this.uri = uri;
        this.httpClient = httpClient;
        this.beacon = beacon;
        this.authToken = authToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        HttpEntity responseEntity = null;
        try {
            String json = Mappers.writeValueAsString(this.beacon);
            StringEntity entity = new StringEntity(json, UTF8);
            entity.setContentType(APPLICATION_JSON);
            HttpPost post = new HttpPost(this.uri);
            post.setEntity(entity);
            post.setHeader("Authorization", this.authToken);
            HttpResponse response = this.httpClient.execute(post);
            responseEntity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            LOG.trace("Got: {}", (Object)statusLine.getStatusCode());
            if (responseEntity == null) return;
        }
        catch (SocketTimeoutException e) {
            LOG.trace("Dropped beacon: {}", (Object)e.getMessage());
            return;
        }
        catch (Exception e2) {
            LOG.warn("Could not send beacon", (Throwable)e2);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (responseEntity != null) {
                EntityUtils.consumeQuietly(responseEntity);
            }
        }
        EntityUtils.consumeQuietly(responseEntity);
        return;
    }
}

