/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.directbeacon;

import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.apache.http.client.config.RequestConfig;
import com.groupbyinc.common.apache.http.impl.client.CloseableHttpClient;
import com.groupbyinc.common.apache.http.impl.client.HttpClientBuilder;
import com.groupbyinc.common.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.groupbyinc.common.directbeacon.DirectBeacon;
import com.groupbyinc.common.directbeacon.DirectBeaconClientTask;
import com.groupbyinc.common.jackson.Mappers;
import com.groupbyinc.common.util.ThreadUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DirectBeaconClient
implements AutoCloseable {
    public static final DirectBeaconClient EMPTY = new DirectBeaconClient(){

        @Override
        public <T> void send(String uriString, DirectBeacon<T> beacon, String authToken) {
        }
    };
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int CONNECTION_REQUEST_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 1000;
    private final CloseableHttpClient httpClient;

    public DirectBeaconClient() {
        this(DirectBeaconClient.createHttpClient());
    }

    public DirectBeaconClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private static CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(200);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(5000).setSocketTimeout(1000).build();
        return clientBuilder.setConnectionManager(cm).setDefaultRequestConfig(requestConfig).build();
    }

    public <T> void send(String uriString, DirectBeacon<T> beacon, String authToken) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Couldn't send beacon", e);
        }
        this.validate(beacon);
        DirectBeaconClientQueue queue = DirectBeaconClientQueue.getInstance();
        queue.offer(new DirectBeaconClientTask<T>(this.httpClient, uri, beacon, authToken));
    }

    public <T> void validate(DirectBeacon<T> beacon) {
        if (beacon == null) {
            throw new IllegalStateException("No beacon to send.");
        }
        if (StringUtils.isBlank(beacon.getResponseId())) {
            throw new IllegalStateException("No responseId found in beacon. You must define a responseId or we can't use this information.");
        }
        if (StringUtils.isBlank(beacon.getCustomerId())) {
            throw new IllegalStateException("No customerId found in beacon. You must define a customerId to send this beacon. \n\n" + Mappers.writeValueAsString(beacon));
        }
    }

    @Override
    public void close() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    private static class DirectBeaconClientQueue {
        private static DirectBeaconClientQueue instance = new DirectBeaconClientQueue();
        private ExecutorService queue = Executors.newFixedThreadPool(100, ThreadUtils.defaultThreadFactory("directbeacon"));

        private DirectBeaconClientQueue() {
        }

        protected static DirectBeaconClientQueue getInstance() {
            return instance;
        }

        protected void offer(DirectBeaconClientTask task) {
            this.queue.submit(task);
        }
    }
}

