/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.BooleanNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@BuiltinFunction(value={"contains/1"})
public class ContainsFunction
implements Function {
    private static final JsonNodeComparator COMPARATOR = JsonNodeComparator.getInstance();

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode value : args.get(0).apply(scope, in)) {
            if (in.getNodeType() != value.getNodeType() || in.isBoolean() && in.asBoolean() != value.asBoolean()) {
                throw JsonQueryTypeException.format("%s (%s) and %s (%s) cannot have their containment checked", new Object[]{in.getNodeType(), in, value.getNodeType(), value});
            }
            out.add(BooleanNode.valueOf(ContainsFunction.contains(value, in)));
        }
        return out;
    }

    private static boolean contains(JsonNode needle, JsonNode haystack) throws JsonQueryException {
        if (haystack.isTextual() && needle.isTextual()) {
            return haystack.asText().contains(needle.asText());
        }
        if (haystack.isArray() && needle.isArray()) {
            for (JsonNode n : needle) {
                boolean found = false;
                for (JsonNode h : haystack) {
                    if (!ContainsFunction.contains(n, h)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (haystack.isObject() && needle.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iter = needle.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> field = iter.next();
                JsonNode tmp = haystack.get(field.getKey());
                if (tmp == null) {
                    return false;
                }
                if (ContainsFunction.contains(field.getValue(), tmp)) continue;
                return false;
            }
            return true;
        }
        return COMPARATOR.compare(haystack, needle) == 0;
    }
}

