/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.BooleanNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"startswith/1"})
public class StartsWithFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("startswith", in, JsonNodeType.STRING);
        String text = in.asText();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode prefix : args.get(0).apply(scope, in)) {
            if (!prefix.isTextual()) {
                throw new JsonQueryException("1st argument of startswith() must evaluate to string");
            }
            out.add(BooleanNode.valueOf(text.startsWith(prefix.asText())));
        }
        return out;
    }
}

