/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@BuiltinFunction(value={"to_entries/0"})
public class ToEntriesFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("to_entries", in, JsonNodeType.OBJECT);
        ArrayNode out = scope.getObjectMapper().createArrayNode();
        Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
        while (iter.hasNext()) {
            Map.Entry<String, JsonNode> entry = iter.next();
            ObjectNode entryNode = scope.getObjectMapper().createObjectNode();
            entryNode.set("key", new TextNode(entry.getKey()));
            entryNode.set("value", entry.getValue());
            out.add(entryNode);
        }
        return Collections.singletonList(out);
    }
}

