/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.operators;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Strings;
import com.groupbyinc.common.jackson.jq.internal.operators.BinaryOperator;
import java.util.Iterator;
import java.util.Map;

public class MultiplyOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long r = lhs.asLong() * rhs.asLong();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() * rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isTextual() && rhs.canConvertToInt()) {
            int count = rhs.asInt();
            if (count <= 0) {
                return NullNode.getInstance();
            }
            return new TextNode(Strings.repeat(lhs.asText(), count));
        }
        if (lhs.isObject() && rhs.isObject()) {
            return MultiplyOperator.mergeRecursive(mapper, (ObjectNode)lhs, (ObjectNode)rhs);
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be multiplied");
    }

    private static ObjectNode mergeRecursive(ObjectMapper mapper, ObjectNode lhs, ObjectNode rhs) {
        ObjectNode result = mapper.createObjectNode();
        Iterator<Map.Entry<String, JsonNode>> liter = lhs.fields();
        while (liter.hasNext()) {
            Map.Entry<String, JsonNode> e = liter.next();
            result.set(e.getKey(), e.getValue());
        }
        Iterator<Map.Entry<String, JsonNode>> riter = rhs.fields();
        while (riter.hasNext()) {
            JsonNode r;
            Map.Entry<String, JsonNode> e = riter.next();
            JsonNode l = result.get(e.getKey());
            JsonNode resolved = r = e.getValue();
            if (l != null && l.isObject() && r.isObject()) {
                resolved = MultiplyOperator.mergeRecursive(mapper, (ObjectNode)l, (ObjectNode)r);
            }
            result.set(e.getKey(), resolved);
        }
        return result;
    }

    @Override
    public String image() {
        return "*";
    }
}

