/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.operators;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.operators.BinaryOperator;
import java.util.Iterator;
import java.util.Map;

public class PlusOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long r = lhs.asLong() + rhs.asLong();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() + rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isArray() && rhs.isArray()) {
            ArrayNode result = mapper.createArrayNode();
            result.addAll((ArrayNode)lhs);
            result.addAll((ArrayNode)rhs);
            return result;
        }
        if (lhs.isTextual() && rhs.isTextual()) {
            return new TextNode(lhs.asText() + rhs.asText());
        }
        if (lhs.isObject() && rhs.isObject()) {
            ObjectNode result = mapper.createObjectNode();
            Iterator<Map.Entry<String, JsonNode>> liter = lhs.fields();
            while (liter.hasNext()) {
                Map.Entry<String, JsonNode> e = liter.next();
                result.set(e.getKey(), e.getValue());
            }
            Iterator<Map.Entry<String, JsonNode>> riter = rhs.fields();
            while (riter.hasNext()) {
                Map.Entry<String, JsonNode> e = riter.next();
                result.set(e.getKey(), e.getValue());
            }
            return result;
        }
        if (lhs.isNull()) {
            return rhs;
        }
        if (rhs.isNull()) {
            return lhs;
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be added");
    }

    @Override
    public String image() {
        return "+";
    }
}

