/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.binaryop;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.operators.BinaryOperator;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import java.util.ArrayList;
import java.util.List;

public abstract class SimpleBinaryOperatorExpression
extends BinaryOperatorExpression {
    private BinaryOperator operator;

    public SimpleBinaryOperatorExpression(JsonQuery lhs, JsonQuery rhs, BinaryOperator operator) {
        super(lhs, rhs, operator.image());
        this.operator = operator;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode l : this.lhs.apply(scope, in)) {
            for (JsonNode r : this.rhs.apply(scope, in)) {
                out.add(this.operator.apply(scope.getObjectMapper(), l, r));
            }
        }
        return out;
    }
}

