/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Range;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedEmptyFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedIndexFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedRangeFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedStringFieldAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BracketFieldAccess
extends FieldAccess {
    private JsonQuery end;
    private JsonQuery begin;
    private boolean isRange;

    public BracketFieldAccess(JsonQuery src, JsonQuery begin, boolean permissive) {
        super(src, permissive);
        this.begin = begin;
        this.isRange = false;
    }

    public BracketFieldAccess(JsonQuery src, JsonQuery begin, JsonQuery end, boolean permissive) {
        super(src, permissive);
        this.begin = begin;
        this.end = end;
        this.isRange = true;
    }

    public String toString() {
        if (this.isRange) {
            return String.format("%s[%s : %s]%s", this.target, this.begin == null ? "" : this.begin, this.end == null ? "" : this.end, this.permissive ? "?" : "");
        }
        return String.format("%s[%s]%s", this.target, this.begin, this.permissive ? "?" : "");
    }

    @Override
    public ResolvedFieldAccess resolveFieldAccess(Scope scope, JsonNode in) throws JsonQueryException {
        if (this.isRange) {
            List<JsonNode> accessorBeginTuple = this.begin == null ? Collections.singletonList(new IntNode(0)) : this.begin.apply(scope, in);
            List<JsonNode> accessorEndTuple = this.end == null ? Collections.singletonList(new IntNode(Integer.MAX_VALUE)) : this.end.apply(scope, in);
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (JsonNode accessorBegin : accessorBeginTuple) {
                for (JsonNode accessorEnd : accessorEndTuple) {
                    if (JsonNodeUtils.isIntegralNumber(accessorBegin) && JsonNodeUtils.isIntegralNumber(accessorEnd)) {
                        long indexBegin = accessorBegin.asLong();
                        long indexEnd = accessorEnd.asLong();
                        ranges.add(new Range(indexBegin, indexEnd));
                        continue;
                    }
                    if (!this.permissive) {
                        throw JsonQueryException.format("Start and end indices of an %s slice must be numbers", new Object[]{in.getNodeType()});
                    }
                    return new ResolvedEmptyFieldAccess(this.permissive);
                }
            }
            return new ResolvedRangeFieldAccess(this.permissive, ranges);
        }
        ArrayList<Long> indices = new ArrayList<Long>();
        ArrayList<String> keys = new ArrayList<String>();
        List<JsonNode> accessorTuple = this.begin.apply(scope, in);
        for (JsonNode accessor : accessorTuple) {
            if (JsonNodeUtils.isIntegralNumber(accessor)) {
                long index = accessor.asLong();
                indices.add(index);
                continue;
            }
            if (accessor.isTextual()) {
                String key = accessor.asText();
                keys.add(key);
                continue;
            }
            if (!this.permissive) {
                throw JsonQueryException.format("Cannot index %s with %s", new Object[]{in.getNodeType(), accessor.getNodeType()});
            }
            return new ResolvedEmptyFieldAccess(this.permissive);
        }
        if (!indices.isEmpty() && !keys.isEmpty()) {
            throw new JsonQueryException("bad index");
        }
        if (!indices.isEmpty()) {
            return new ResolvedIndexFieldAccess(this.permissive, indices);
        }
        if (!keys.isEmpty()) {
            return new ResolvedStringFieldAccess(this.permissive, keys);
        }
        return new ResolvedEmptyFieldAccess(this.permissive);
    }
}

