/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.module.afterburner.ser;

import com.groupbyinc.common.jackson.databind.BeanDescription;
import com.groupbyinc.common.jackson.databind.JsonSerializer;
import com.groupbyinc.common.jackson.databind.SerializationConfig;
import com.groupbyinc.common.jackson.databind.introspect.AnnotatedMember;
import com.groupbyinc.common.jackson.databind.introspect.AnnotatedMethod;
import com.groupbyinc.common.jackson.databind.ser.BeanPropertyWriter;
import com.groupbyinc.common.jackson.databind.ser.BeanSerializerModifier;
import com.groupbyinc.common.jackson.databind.util.ClassUtil;
import com.groupbyinc.common.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.groupbyinc.common.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import com.groupbyinc.common.jackson.module.afterburner.ser.PropertyAccessorCollector;
import com.groupbyinc.common.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;

public class SerializerModifier
extends BeanSerializerModifier {
    protected final MyClassLoader _classLoader;

    public SerializerModifier(ClassLoader cl) {
        this._classLoader = cl == null ? null : new MyClassLoader(cl, false);
    }

    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        Class<?> beanClass = beanDesc.getBeanClass();
        if (!MyClassLoader.canAddClassInPackageOf(beanClass)) {
            return beanProperties;
        }
        if (this._classLoader != null && Modifier.isPrivate(beanClass.getModifiers())) {
            return beanProperties;
        }
        PropertyAccessorCollector collector = this.findProperties(beanClass, config, beanProperties);
        if (collector.isEmpty()) {
            return beanProperties;
        }
        BeanPropertyAccessor acc = null;
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            BeanPropertyWriter bpw = it.next();
            if (!(bpw instanceof OptimizedBeanPropertyWriter)) continue;
            if (acc == null) {
                acc = collector.findAccessor(this._classLoader);
            }
            it.set((BeanPropertyWriter)((OptimizedBeanPropertyWriter)bpw).withAccessor(acc));
        }
        return beanProperties;
    }

    protected PropertyAccessorCollector findProperties(Class<?> beanClass, SerializationConfig config, List<BeanPropertyWriter> beanProperties) {
        PropertyAccessorCollector collector = new PropertyAccessorCollector(beanClass);
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            BeanPropertyWriter bpw = it.next();
            Class<?> type = bpw.getPropertyType();
            AnnotatedMember member = bpw.getMember();
            Member jdkMember = member.getMember();
            if (jdkMember == null || Modifier.isPrivate(jdkMember.getModifiers()) || bpw.hasSerializer() && !this.isDefaultSerializer(config, bpw.getSerializer()) || bpw.isUnwrapping() || bpw.getClass() != BeanPropertyWriter.class) continue;
            boolean isMethod = member instanceof AnnotatedMethod;
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    if (isMethod) {
                        it.set(collector.addIntGetter(bpw));
                        continue;
                    }
                    it.set(collector.addIntField(bpw));
                    continue;
                }
                if (type == Long.TYPE) {
                    if (isMethod) {
                        it.set(collector.addLongGetter(bpw));
                        continue;
                    }
                    it.set(collector.addLongField(bpw));
                    continue;
                }
                if (type != Boolean.TYPE) continue;
                if (isMethod) {
                    it.set(collector.addBooleanGetter(bpw));
                    continue;
                }
                it.set(collector.addBooleanField(bpw));
                continue;
            }
            if (type == String.class) {
                if (isMethod) {
                    it.set(collector.addStringGetter(bpw));
                    continue;
                }
                it.set(collector.addStringField(bpw));
                continue;
            }
            if (isMethod) {
                it.set(collector.addObjectGetter(bpw));
                continue;
            }
            it.set(collector.addObjectField(bpw));
        }
        return collector;
    }

    protected boolean isDefaultSerializer(SerializationConfig config, JsonSerializer<?> ser) {
        return ClassUtil.isJacksonStdImpl(ser);
    }
}

