package com.groupbyinc.common.manager.health;

import java.util.ArrayList;
import java.util.List;

import static com.groupbyinc.common.manager.health.HealthStatus.green;

/**
 * Health status response
 *
 * @author Osman Currim
 * @author Alan Czajkowski
 */
public class HealthStatusResponse {

  private HealthStatus status;

  private List<Object> details;

  public HealthStatusResponse() {
    this(green);
  }

  public HealthStatusResponse(HealthStatus status) {
    this.status = status;
    this.details = new ArrayList<Object>();
  }

  public HealthStatus getStatus() {
    return status;
  }

  public HealthStatusResponse setStatus(HealthStatus status) {
    this.status = status;
    return this;
  }

  public List<Object> getDetails() {
    return details;
  }

  public HealthStatusResponse addDetail(Object detail) {
    if (detail != null) {
      details.add(detail);
    }
    return this;
  }

  public HealthStatusResponse addDetails(List<Object> details) {
    if (details != null) {
      this.details.addAll(details);
    }
    return this;
  }
}
