package com.groupbyinc.common.util.exception;

import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static org.apache.commons.lang3.StringUtils.join;

public abstract class MultipleErrorsException extends Exception {

  private Collection<String> errors;

  public MultipleErrorsException(Collection<String> errors) {
    super(buildMessageFromErrors(isEmpty(errors) ? Stream.empty() : errors.stream()));
    this.errors = (isEmpty(errors)) ? emptyList() : errors.stream().filter(StringUtils::isNotEmpty).collect(toList());
  }

  public MultipleErrorsException(String... errors) {
    this(asList(errors));
  }

  public Collection<String> getErrors() {
    return errors;
  }

  private static String buildMessageFromErrors(Stream<String> errorStream) {
    List<String> errorMessages = errorStream.map(StringUtils::trim).filter(StringUtils::isNotEmpty).collect(toList());
    if (isEmpty(errorMessages)) {
      return "No error details available";
    } else if (errorMessages.size() == 1) {
      return errorMessages.get(0);
    } else {
      return "Multiple errors occurred: " + join(errorMessages, ", ");
    }
  }
}
