/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.test.util;

import com.groupbyinc.common.apache.commons.collections4.CollectionUtils;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.jackson.Mappers;
import com.groupbyinc.common.jackson.core.JsonParser;
import com.groupbyinc.common.jackson.core.JsonProcessingException;
import com.groupbyinc.common.jackson.core.TreeNode;
import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(AssertUtils.class);
    private static final int JSON_SPACING = 4;

    private AssertUtils() {
    }

    public static <E extends Comparable<E>> void assertListEqualsIgnoreOrder(List<E> expected, List<E> actual) {
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
    }

    public static void assertJsonLinesEquals(List<String> expectedLines, List<String> actualLines) {
        if (expectedLines.size() != actualLines.size()) {
            Assert.fail((String)("Expected line count: " + expectedLines.size() + " Actual line count: " + actualLines.size()));
        }
        Collections.sort(expectedLines);
        Collections.sort(actualLines);
        for (int i = 0; i < expectedLines.size(); ++i) {
            AssertUtils.assertJsonEquals(expectedLines.get(i), actualLines.get(i));
        }
    }

    public static void assertJsonEquals(String expectedJson, Object actual) {
        AssertUtils.assertJsonEquals(".", expectedJson, actual);
    }

    public static void assertJsonEquals(String key, String expectedJson, Object actual) {
        AssertUtils.assertJsonEqualsWithMsg(null, key, expectedJson, actual);
    }

    public static void assertJsonEqualsWithMsg(String msg, String key, String expectedJson, Object actual) {
        String actualJson = actual instanceof String ? (String)actual : Mappers.writeValueAsString((Object)actual);
        try {
            if (StringUtils.isNotBlank(expectedJson) && StringUtils.isBlank(actualJson)) {
                Assert.fail((String)"no actual json received to compare to");
            } else if (StringUtils.isBlank(expectedJson) && StringUtils.isNotBlank(actualJson)) {
                Assert.fail((String)"no expected json given to compare to");
            }
            boolean isArrayCheck = StringUtils.startsWith(expectedJson, "[");
            boolean isValueCheck = !StringUtils.startsWith(expectedJson, "{");
            JsonQuery jq = JsonQuery.compile((String)(key + (isArrayCheck ? "[]" : "")));
            ObjectMapper mapper = new ObjectMapper();
            JsonNode actualJsonNode = mapper.readTree(actualJson);
            List partials = jq.apply(Scope.newEmptyScope(), actualJsonNode).stream().map(p -> {
                try {
                    return mapper.treeToValue((TreeNode)p, Object.class);
                }
                catch (JsonProcessingException e) {
                    Assert.fail((String)("unable to parse json" + e.getMessage()));
                    return null;
                }
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(partials)) {
                Assert.fail((String)"provided jq query does not match any partial json");
            } else if (isArrayCheck) {
                AssertUtils.assertJsonArrayEquals(msg, expectedJson, mapper.writeValueAsString(partials));
            } else if (isValueCheck) {
                Assert.assertEquals((String)msg, (Object)expectedJson.replaceAll("\"", "'"), (Object)mapper.writeValueAsString(partials.get(0)).replaceAll("\"", "'"));
            } else {
                Map value = (Map)Mappers.getStrictReader((boolean)false).with(JsonParser.Feature.ALLOW_TRAILING_COMMA).forType(Map.class).readValue(expectedJson.getBytes());
                JSONObject expected = new JSONObject(value);
                JSONObject actualJsonObject = new JSONObject(mapper.writeValueAsString(partials.get(0)));
                JSONCompareResult result = JSONCompare.compareJSON((JSONObject)expected, (JSONObject)actualJsonObject, (JSONComparator)new LenientDoublesJsonComparator());
                AssertUtils.verifyJson(result, expected.toString(4), actualJsonObject.toString(4));
            }
        }
        catch (Exception e) {
            LOG.warn("expected: {}\n  actual: {}\n{}", new Object[]{expectedJson, actualJson, e.getMessage()});
            String errorMsg = "invalid expected json";
            if (StringUtils.isNotBlank(msg)) {
                errorMsg = ": " + msg;
            }
            Assert.fail((String)(errorMsg + "\n expected: " + expectedJson));
        }
    }

    private static void assertJsonArrayEquals(String msg, String expectedJson, Object actual) {
        String actualJson = actual instanceof String ? (String)actual : Mappers.writeValueAsString((Object)actual);
        try {
            List value = (List)Mappers.getStrictReader((boolean)false).with(JsonParser.Feature.ALLOW_TRAILING_COMMA).forType(List.class).readValue(expectedJson.getBytes());
            JSONArray expected = new JSONArray((Collection)value);
            JSONArray actualArray = new JSONArray(actualJson);
            JSONCompareResult result = JSONCompare.compareJSON((JSONArray)expected, (JSONArray)actualArray, (JSONComparator)new LenientDoublesJsonComparator());
            AssertUtils.verifyJson(result, expected.toString(4), actualArray.toString(4));
        }
        catch (Exception e) {
            LOG.warn("expected: {}\n  actual: {}\n{}", new Object[]{expectedJson, actualJson, e.getMessage()});
            String errorMsg = "invalid expected json";
            if (StringUtils.isNotBlank(msg)) {
                errorMsg = ": " + msg;
            }
            Assert.fail((String)(errorMsg + "\n expected: " + expectedJson));
        }
    }

    private static void verifyJson(JSONCompareResult result, String expectedFormatted, String actualFormatted) {
        if (!result.passed()) {
            Assert.assertEquals((String)String.format("expected: %s\n\nactual: %s\n\nmsg: %s\n", expectedFormatted, actualFormatted, result.getMessage()), (Object)expectedFormatted, (Object)actualFormatted);
            Assert.assertTrue((boolean)result.passed());
        }
    }

    public static void assertJsonEqualsWithMsg(String msg, String expectedJson, Object actual) {
        AssertUtils.assertJsonEqualsWithMsg(msg, ".", expectedJson, actual);
    }

    public static class LenientDoublesJsonComparator
    extends DefaultComparator {
        private static final double MARGIN = 0.1;

        private LenientDoublesJsonComparator() {
            super(JSONCompareMode.STRICT);
        }

        private double parseMantissa(Number value) {
            return Double.parseDouble(value.toString().split("E", 2)[0]);
        }

        private int parseExponent(Number value) {
            String[] split = value.toString().split("E", 2);
            return split.length < 2 ? 1 : Integer.parseInt(split[1]);
        }

        public void compareValues(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) throws JSONException {
            if (expectedValue instanceof Number && actualValue instanceof Number) {
                Number expectedNumber = (Number)expectedValue;
                Number actualNumber = (Number)actualValue;
                if (this.parseExponent(expectedNumber) != this.parseExponent(actualNumber) || Math.abs(this.parseMantissa(expectedNumber) - this.parseMantissa(actualNumber)) > 0.1) {
                    result.fail(prefix, expectedValue, actualValue);
                }
            } else {
                super.compareValues(prefix, expectedValue, actualValue, result);
            }
        }
    }
}

