/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.test;

import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CircleCIParallelRule
implements TestRule {
    private static final transient Logger LOG = LoggerFactory.getLogger(CircleCIParallelRule.class);

    private Statement skipTest(final int currentNode, final int targetNode) {
        return new Statement(){

            public void evaluate() {
                Assume.assumeTrue((String)("Skipping test, currentNode: " + currentNode + ", targetNode: " + targetNode), (boolean)false);
            }
        };
    }

    public Statement apply(Statement statement, Description description) {
        int targetNode;
        String circleNodeTotal = System.getenv("CIRCLE_NODE_TOTAL");
        String circleNodeIndex = System.getenv("CIRCLE_NODE_INDEX");
        if (StringUtils.isBlank(circleNodeIndex) || StringUtils.isBlank(circleNodeTotal)) {
            LOG.trace("Running locally, so skipping");
            return statement;
        }
        String testName = description.getClassName() + "#" + description.getMethodName();
        int currentNode = Integer.parseInt(circleNodeIndex);
        return currentNode == (targetNode = Math.abs(testName.hashCode()) % Integer.parseInt(circleNodeTotal)) ? statement : this.skipTest(currentNode, targetNode);
    }
}

