/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private String parent;
    private String name;
    private boolean includeThreadNumber;

    public DefaultForkJoinWorkerThreadFactory(String parent, String name, boolean includeThreadNumber) {
        this.parent = parent;
        this.name = name;
        this.includeThreadNumber = includeThreadNumber;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        WorkerThread t = new WorkerThread(pool);
        StringBuilder overrideName = new StringBuilder();
        overrideName.append(this.parent);
        overrideName.append(":");
        overrideName.append(this.name);
        if (this.includeThreadNumber) {
            overrideName.append(":");
            overrideName.append(this.threadNumber.incrementAndGet());
        }
        t.setName(overrideName.toString());
        return t;
    }

    private static class WorkerThread
    extends ForkJoinWorkerThread {
        private WorkerThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

