/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.bitbucket.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.groupcdg.pitest.bitbucket.api.BitBucketCredentials;
import com.groupcdg.pitest.bitbucket.api.json.ConfiguredMapper;
import com.groupcdg.pitest.bitbucket.api.json.server.Activities;
import com.groupcdg.pitest.bitbucket.api.json.server.Anchor;
import com.groupcdg.pitest.bitbucket.api.json.server.JsonComment;
import com.groupcdg.pitest.bitbucket.api.json.server.Value;
import com.groupcdg.pitest.pr.GitProviderApi;
import com.groupcdg.pitest.pr.http.SimpleHttpClient;
import com.groupcdg.pitest.pr.model.Comment;
import com.groupcdg.pitest.pr.model.CommentEntity;
import com.groupcdg.pitest.pr.model.CommentId;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BitBucketServer
implements GitProviderApi {
    private final BitBucketCredentials credentials;

    BitBucketServer(BitBucketCredentials credentials) {
        this.credentials = credentials;
    }

    public static GitProviderApi connect(BitBucketCredentials credentials) {
        return new BitBucketServer(credentials);
    }

    static <T> Stream<T> optionalToStream(Optional<T> opt) {
        if (opt.isPresent()) {
            return Stream.of(opt.get());
        }
        return Stream.empty();
    }

    public void createComment(Comment comment) {
        String json = this.asJson(comment);
        SimpleHttpClient client = this.credentials.connect();
        client.post(this.makePRUrlBase("/comments"), json);
    }

    public List<CommentEntity> existingComments() {
        return this.fetchComments(URI.create(this.makePRUrlBase("/activities")), null);
    }

    public void deleteComment(CommentId id) {
        SimpleHttpClient client = this.credentials.connect();
        client.delete(this.makePRUrlBase("/comments/" + id.id() + "?version=" + id.version()));
    }

    private List<CommentEntity> fetchComments(URI uri, Integer start) {
        SimpleHttpClient client = this.credentials.connect();
        return (List)client.get(this.pagedURL(uri, start), r -> this.asCommentEntities(uri, (InputStream)r));
    }

    private List<CommentEntity> asCommentEntities(URI uri, InputStream response) {
        try {
            Activities json = (Activities)ConfiguredMapper.mapper().readValue(response, Activities.class);
            List<CommentEntity> comments = json.getValues().stream().flatMap(this::jsonToComment).collect(Collectors.toList());
            if (json.getNextPageStart() != null) {
                comments.addAll(this.fetchComments(uri, json.getNextPageStart()));
            }
            return comments;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String pagedURL(URI uri, Integer start) {
        if (start == null) {
            return uri.toString();
        }
        return uri.toString() + "?start=" + start;
    }

    private Stream<CommentEntity> jsonToComment(Value value) {
        return BitBucketServer.optionalToStream(Optional.ofNullable(value.getComment()).map(c -> new CommentEntity(CommentId.versioned((long)c.getId(), (int)c.getVersion()), this.asComment((JsonComment)c, value.getCommentAnchor()))));
    }

    private Comment asComment(JsonComment comment, Anchor anchor) {
        if (anchor != null) {
            return Comment.annotation((String)comment.getText(), (String)anchor.getPath(), (Integer)anchor.getLine());
        }
        return Comment.topLevel((String)comment.getText());
    }

    private String asJson(Comment comment) {
        Anchor anchor = comment.path().map(p -> this.asAnchor(comment, (String)p)).orElse(null);
        JsonComment json = new JsonComment();
        json.setText(comment.markdown());
        json.setAnchor(anchor);
        try {
            return ConfiguredMapper.mapper().writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private Anchor asAnchor(Comment comment, String path) {
        Anchor anchor = new Anchor();
        anchor.setPath(path);
        anchor.setLine(comment.line());
        anchor.setFileType("TO");
        anchor.setLineType("ADDED");
        return anchor;
    }

    private String makePRUrlBase(String s) {
        return this.credentials.baseUrl() + "/projects/" + this.credentials.workspace() + "/repos/" + this.credentials.repoSlug() + "/pull-requests/" + this.credentials.pullRequestId() + s;
    }
}

