/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.bitbucket.api;

import com.groupcdg.pitest.bitbucket.api.BitBucketCredentials;
import com.groupcdg.pitest.bitbucket.api.json.ConfiguredMapper;
import com.groupcdg.pitest.bitbucket.api.json.cloud.Comments;
import com.groupcdg.pitest.bitbucket.api.json.cloud.Content;
import com.groupcdg.pitest.bitbucket.api.json.cloud.Inline;
import com.groupcdg.pitest.bitbucket.api.json.cloud.JsonComment;
import com.groupcdg.pitest.bitbucket.api.json.cloud.Value;
import com.groupcdg.pitest.pr.GitProviderApi;
import com.groupcdg.pitest.pr.http.SimpleHttpClient;
import com.groupcdg.pitest.pr.model.Comment;
import com.groupcdg.pitest.pr.model.CommentEntity;
import com.groupcdg.pitest.pr.model.CommentId;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;

public class BitBucketCloud
implements GitProviderApi {
    private final BitBucketCredentials credentials;

    public BitBucketCloud(BitBucketCredentials credentials) {
        this.credentials = credentials;
    }

    public static GitProviderApi connect(BitBucketCredentials credentials) {
        return new BitBucketCloud(credentials);
    }

    public List<CommentEntity> existingComments() {
        return this.fetchComments(URI.create(this.makePRUrlBase("/comments?q=deleted=false")));
    }

    public void deleteComment(CommentId id) {
        SimpleHttpClient client = this.credentials.connect();
        client.delete(this.makePRUrlBase("/comments/" + id.id()));
    }

    private List<CommentEntity> fetchComments(URI url) {
        SimpleHttpClient client = this.credentials.connect();
        return (List)client.get(url, this::asComments);
    }

    private List<CommentEntity> asComments(InputStream response) {
        try {
            Comments json = (Comments)ConfiguredMapper.mapper().readValue(response, Comments.class);
            List<CommentEntity> comments = json.getValues().stream().map(this::jsonToComment).collect(Collectors.toList());
            if (json.getNext() != null) {
                comments.addAll(this.fetchComments(json.getNext()));
            }
            return comments;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private CommentEntity jsonToComment(Value value) {
        Comment comment = value.getInline() != null ? Comment.annotation((String)value.getContent().getRaw(), (String)value.getInline().getPath(), (Integer)value.getInline().getFrom()) : Comment.topLevel((String)value.getContent().getRaw());
        return new CommentEntity(CommentId.unversioned((long)value.getId()), comment);
    }

    public void createComment(Comment comment) {
        String json = this.asJson(comment);
        SimpleHttpClient client = this.credentials.connect();
        client.post(this.makePRUrlBase("/comments"), json);
    }

    private String asJson(Comment comment) {
        Inline inline = comment.path().map(p -> new Inline((String)p, comment.line())).orElse(null);
        Content content = new Content();
        content.setRaw(comment.markdown());
        JsonComment json = new JsonComment();
        json.setContent(content);
        json.setInline(inline);
        try {
            return ConfiguredMapper.mapper().writeValueAsString((Object)json);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String makePRUrlBase(String s) {
        return this.credentials.baseUrl() + "/repositories/" + this.credentials.workspace() + "/" + this.credentials.repoSlug() + "/pullrequests/" + this.credentials.pullRequestId() + s;
    }
}

