/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.bitbucket.api;

import com.groupcdg.pitest.bitbucket.api.BitBucketAuth;
import com.groupcdg.pitest.pr.http.SimpleHttpClient;

public class BitBucketCredentials {
    private final BitBucketAuth auth;
    private final String projectOrWorkspace;
    private final String repoPath;
    private final Integer pullRequest;
    private final String baseUrl;

    public BitBucketCredentials(BitBucketAuth auth, String projectOrWorkspace, String repoPath, Integer pullRequest, String baseUrl) {
        this.auth = auth;
        this.projectOrWorkspace = projectOrWorkspace;
        this.repoPath = repoPath;
        this.pullRequest = pullRequest;
        this.baseUrl = BitBucketCredentials.removeTrailingSlash(baseUrl);
    }

    SimpleHttpClient connect() {
        return this.auth.connect();
    }

    public String workspace() {
        return this.projectOrWorkspace;
    }

    public String repoSlug() {
        return this.repoPath;
    }

    public Integer pullRequestId() {
        return this.pullRequest;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    private static String removeTrailingSlash(String baseUrl) {
        if (baseUrl != null && baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }
}

