/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.gitlab.bitbucket;

import com.groupcdg.pitest.aggregate.AbstractAggregationMojo;
import com.groupcdg.pitest.aggregate.SummaryAggregator;
import com.groupcdg.pitest.gitlab.GitlabCredentials;
import com.groupcdg.pitest.gitlab.GitlabUploader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="gitlab", defaultPhase=LifecyclePhase.VERIFY, aggregator=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE)
public class GitlabMojo
extends AbstractAggregationMojo {
    @Parameter(required=true, property="repoToken", defaultValue="${env.REPO_TOKEN}")
    private String repoToken;
    @Parameter(required=true, property="projectId", defaultValue="${env.CI_PROJECT_ID}")
    private String projectId;
    @Parameter(required=true, property="mergeRequestIID", defaultValue="${env.CI_MERGE_REQUEST_IID}")
    private Integer mergeRequest;
    @Parameter(required=true, property="gitlabUrl", defaultValue="${env.CI_SERVER_URL}")
    private String gitlabUrl;
    private final GitlabUploader gitlab;
    private final SummaryAggregator summary;

    public GitlabMojo() {
        this(FileSystems.getDefault(), new GitlabUploader());
    }

    public GitlabMojo(FileSystem fs, GitlabUploader gitlab) {
        super(fs);
        this.gitlab = gitlab;
        this.summary = new SummaryAggregator();
    }

    public void execute() throws MojoExecutionException {
        try {
            GitlabCredentials credentials = new GitlabCredentials(this.projectId, this.repoToken, this.mergeRequest, this.gitlabUrl);
            this.gitlab.execute(credentials, this.annotations(), this.makeSummary());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error uploading to gitlab", e);
        }
    }

    protected String defaultMutantEmoji() {
        return ":imp:";
    }

    protected String defaultKilledEmoji() {
        return ":100:";
    }

    private String makeSummary() {
        if (!this.summaryConfig().isEnabled()) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.summary.createSummaryFromResults(this.simpleJson(), this.summaryConfig(), (Writer)new OutputStreamWriter(bos));
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }
}

