/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr;

import com.groupcdg.pitest.annotation.SourceAnnotation;
import com.groupcdg.pitest.annotation.SourceAnnotationMother;
import com.groupcdg.pitest.pr.AnnotationEncoder;
import com.groupcdg.pitest.pr.EncodeStyle;
import java.io.IOException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AnnotationEncoderTest {
    AnnotationEncoder underTest = new AnnotationEncoder(EncodeStyle.LINK);

    AnnotationEncoderTest() {
    }

    @Test
    void decodesWhatItEncodesWithLinkStyle() throws IOException {
        SourceAnnotation annotation = SourceAnnotationMother.anAnnotation();
        String encoded = this.underTest.encode(annotation);
        Assertions.assertThat((Stream)this.underTest.decode(encoded)).contains((Object[])new SourceAnnotation[]{annotation});
    }

    @Test
    void decodesWhatItEncodesWithXmlStyle() throws IOException {
        this.underTest = new AnnotationEncoder(EncodeStyle.LINK);
        SourceAnnotation annotation = SourceAnnotationMother.anAnnotation();
        String encoded = this.underTest.encode(annotation);
        Assertions.assertThat((Stream)this.underTest.decode(encoded)).contains((Object[])new SourceAnnotation[]{annotation});
    }

    @Test
    void decodesWhenThereIsOtherContent() throws IOException {
        SourceAnnotation annotation = SourceAnnotationMother.anAnnotation();
        String encoded = this.underTest.encode(annotation);
        Assertions.assertThat((Stream)this.underTest.decode("some stuff" + encoded + "more stuff")).contains((Object[])new SourceAnnotation[]{annotation});
    }

    @Test
    void doesNotDecodeWhenNoCommentPresent() throws IOException {
        Assertions.assertThat((Stream)this.underTest.decode("not relevant")).isEmpty();
    }

    @Test
    void doesNotDecodeWhenCommentNotClosed() throws IOException {
        Assertions.assertThat((Stream)this.underTest.decode("[pitest]: # (stuff")).isEmpty();
    }

    @Test
    void errorsWhenContentMalformed() {
        Assertions.assertThatCode(() -> this.underTest.decode("[pitest]: # (cantdecodeme --)")).hasMessageContaining("Invalid");
    }

    @Test
    void recognisesPitestComments() {
        Assertions.assertThat((boolean)AnnotationEncoder.hasEncodedContent((String)"[pitest]: # (stuff)")).isTrue();
        Assertions.assertThat((boolean)AnnotationEncoder.hasEncodedContent((String)"just mentions pitest")).isFalse();
    }

    @Test
    void recognisesLegacyEncodedComments() {
        Assertions.assertThat((boolean)AnnotationEncoder.hasEncodedContent((String)"<!-- pitest stuff -->")).isTrue();
        Assertions.assertThat((boolean)AnnotationEncoder.hasEncodedContent((String)"<!-- not pitest -->")).isFalse();
    }

    @Test
    void decodesXmlStyleGitlabComments() throws IOException {
        AnnotationEncoder underTest = new AnnotationEncoder(EncodeStyle.XML);
        String legacy = "<!-- pitest eyJmaWxlIjoiQUZpbGUuamF2YSIsInRpdGxlIjoiQSB0aXRsZSIsImxpbmUiOjQyLCJtZXNzYWdlIjoiQSBtZXNzYWdlIiwiYW5ub3RhdGlvbl9sZXZlbCI6Im5vdGljZSJ9 -->";
        Assertions.assertThat((Stream)underTest.decode(legacy)).isNotEmpty();
    }

    @Test
    void doesNotDecodeLegacyGitlabWhenCommentNotClosed() throws IOException {
        Assertions.assertThat((Stream)this.underTest.decode("<!-- pitest some stuff")).isEmpty();
    }

    @Test
    void errorsWhenXmlStyleGitlabContentMalformed() {
        AnnotationEncoder underTest = new AnnotationEncoder(EncodeStyle.XML);
        Assertions.assertThatCode(() -> underTest.decode("<!-- pitest cantdecodeme -->")).hasMessageContaining("Invalid");
    }
}

