/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr;

import com.groupcdg.pitest.annotation.SourceAnnotation;
import com.groupcdg.pitest.annotation.SourceAnnotationMother;
import com.groupcdg.pitest.pr.AnnotationEncoder;
import com.groupcdg.pitest.pr.EncodeStyle;
import com.groupcdg.pitest.pr.GitProviderApi;
import com.groupcdg.pitest.pr.PRUploader;
import com.groupcdg.pitest.pr.model.Comment;
import com.groupcdg.pitest.pr.model.CommentEntity;
import com.groupcdg.pitest.pr.model.CommentId;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PRUploaderTest {
    PRUploader underTest = new PRUploader(EncodeStyle.LINK);
    GitProviderApi api = (GitProviderApi)Mockito.mock(GitProviderApi.class);

    PRUploaderTest() {
    }

    @Test
    void createsCommentsOnPullRequests() throws Exception {
        this.underTest.execute(this.api, Collections.emptyList(), "summary", false);
        ((GitProviderApi)Mockito.verify((Object)this.api)).createComment((Comment)ArgumentMatchers.argThat(this.hasText("summary")));
    }

    @Test
    void doesNotCreateSummaryWhenTextEmpty() throws Exception {
        this.underTest.execute(this.api, Collections.emptyList(), "", false);
        ((GitProviderApi)Mockito.verify((Object)this.api, (VerificationMode)Mockito.never())).createComment((Comment)ArgumentMatchers.any(Comment.class));
    }

    @Test
    void addsEmptyMutantToSummaryWhenFlagSet() throws IOException {
        this.underTest.execute(this.api, Collections.emptyList(), "summary", true);
        ((GitProviderApi)Mockito.verify((Object)this.api)).createComment((Comment)ArgumentMatchers.argThat(this.hasText("[pitest]: # (eyJsaW5lIjowfQ== --)")));
    }

    @Test
    void createsCommentsForNewMutantsOnly() throws Exception {
        SourceAnnotation annotation = SourceAnnotationMother.anAnnotation();
        annotation.setTitle("This is not good");
        SourceAnnotation existing = SourceAnnotationMother.anAnnotation();
        existing.setTitle("existing");
        this.setupCommentsFor(existing);
        this.underTest.execute(this.api, Arrays.asList(annotation, existing), "", false);
        ((GitProviderApi)Mockito.verify((Object)this.api)).createComment((Comment)ArgumentMatchers.argThat(this.hasText("This is not good")));
        ((GitProviderApi)Mockito.verify((Object)this.api, (VerificationMode)Mockito.never())).createComment((Comment)ArgumentMatchers.argThat(this.hasText("existing")));
    }

    @Test
    void deletesCommentsForStaleMutants() throws Exception {
        SourceAnnotation oldMutant = SourceAnnotationMother.anAnnotation();
        oldMutant.setTitle("I'm gone now");
        SourceAnnotation stillHere = SourceAnnotationMother.anAnnotation();
        stillHere.setTitle("still_here");
        CommentEntity oldComment = this.annotationToComment(oldMutant).asEntity(CommentId.unversioned((long)1L));
        CommentEntity activeComment = this.annotationToComment(stillHere).asEntity(CommentId.unversioned((long)2L));
        this.setupCommentsFor(Arrays.asList(oldComment, activeComment));
        this.underTest.execute(this.api, Arrays.asList(stillHere), "", false);
        ((GitProviderApi)Mockito.verify((Object)this.api)).deleteComment(oldComment.id());
        ((GitProviderApi)Mockito.verify((Object)this.api, (VerificationMode)Mockito.never())).deleteComment(activeComment.id());
    }

    @Test
    void doesNotDeleteNonePitestComments() throws Exception {
        CommentEntity comment = Comment.annotation((String)"I mention pitest but am just a normal comment", (String)"foo", (Integer)1).asEntity(CommentId.unversioned((long)42L));
        CommentEntity pitestComment = this.annotationToComment(SourceAnnotationMother.anAnnotation(), EncodeStyle.LINK).asEntity(CommentId.unversioned((long)101L));
        this.setupCommentsFor(Arrays.asList(comment, pitestComment));
        this.underTest.execute(this.api, Arrays.asList(new SourceAnnotation[0]), "", false);
        ((GitProviderApi)Mockito.verify((Object)this.api, (VerificationMode)Mockito.never())).deleteComment(CommentId.unversioned((long)24L));
        ((GitProviderApi)Mockito.verify((Object)this.api)).deleteComment(CommentId.unversioned((long)101L));
    }

    private void setupCommentsFor(SourceAnnotation ... annotations) {
        List<CommentEntity> comments = IntStream.range(0, annotations.length).mapToObj(i -> new CommentEntity(CommentId.unversioned((long)i), this.annotationToComment(annotations[i]))).collect(Collectors.toList());
        this.setupCommentsFor(comments);
    }

    private void setupCommentsFor(List<CommentEntity> comments) {
        Mockito.when((Object)this.api.existingComments()).thenReturn(comments);
    }

    Comment annotationToComment(SourceAnnotation annotation) {
        return this.annotationToComment(annotation, EncodeStyle.LINK);
    }

    Comment annotationToComment(SourceAnnotation annotation, EncodeStyle style) {
        AnnotationEncoder encoder = new AnnotationEncoder(style);
        return Comment.annotation((String)encoder.encode(annotation), (String)annotation.getFile(), (Integer)annotation.getLine());
    }

    private ArgumentMatcher<Comment> hasText(String expected) {
        return comment -> comment.markdown().contains(expected);
    }
}

