/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.groupcdg.pitest.pr.http.SimpleHttpClient;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SimpleHttpClientTest {
    WireMockServer wireMock = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
    SimpleHttpClient underTest = SimpleHttpClient.connectWithBasicAuth((String)"user", (String)"token");

    SimpleHttpClientTest() {
    }

    @BeforeEach
    void wireMock() {
        this.wireMock.start();
    }

    @AfterEach
    void cleanup() {
        this.wireMock.stop();
    }

    @Test
    void canDelete() {
        this.wireMock.stubFor(WireMock.delete((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(204)));
        Assertions.assertThat((int)this.underTest.delete(this.wireMock.baseUrl() + "/theinternet")).isEqualTo(204);
        this.wireMock.verify(WireMock.exactly((int)1), WireMock.deleteRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/theinternet")));
    }

    @Test
    void throwsWhenDeleteErrors() {
        this.wireMock.stubFor(WireMock.delete((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(500)));
        Assertions.assertThatCode(() -> this.underTest.delete(this.wireMock.baseUrl())).isInstanceOf(UncheckedIOException.class);
    }

    @Test
    void sendsBasicAuthHeaders() {
        this.wireMock.stubFor(WireMock.delete((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(204)));
        this.underTest.delete(this.wireMock.baseUrl() + "/whatever");
        this.wireMock.verify(WireMock.exactly((int)1), WireMock.deleteRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("Authorization", (StringValuePattern)new EqualToPattern("Basic dXNlcjp0b2tlbg==")));
    }

    @Test
    void canPost() {
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(200)));
        Assertions.assertThat((int)this.underTest.post(this.wireMock.baseUrl() + "/haste", "{}")).isEqualTo(200);
        this.wireMock.verify(WireMock.exactly((int)1), WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/haste")));
    }

    @Test
    void throwsWhenPostErrors() {
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(500)));
        Assertions.assertThatCode(() -> this.underTest.post(this.wireMock.baseUrl(), "{}")).isInstanceOf(UncheckedIOException.class);
    }

    @Test
    void passesGetResponsesToSuppliedFunction() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(200).withBody("A STRING")));
        String actual = (String)this.underTest.get(this.wireMock.baseUrl() + "/getME", this::asString);
        Assertions.assertThat((String)actual).isEqualTo("A STRING");
    }

    @Test
    void throwsWhenGetErrors() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(500)));
        Assertions.assertThatCode(() -> this.underTest.get(this.wireMock.baseUrl(), i -> i)).isInstanceOf(UncheckedIOException.class);
    }

    private String asString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }
}

