/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.groupcdg.pitest.annotation.SourceAnnotation;
import com.groupcdg.pitest.pr.ConfiguredMapper;
import com.groupcdg.pitest.pr.EncodeStyle;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Stream;

public class AnnotationEncoder {
    private final EncodeStyle style;

    public AnnotationEncoder(EncodeStyle style) {
        this.style = style;
    }

    public static boolean hasEncodedContent(String markdown) {
        return Arrays.stream(EncodeStyle.values()).anyMatch(s -> markdown.contains(s.startTag()));
    }

    public String encode(SourceAnnotation annotation) {
        try {
            return "\n " + this.style.startTag() + Base64.getEncoder().encodeToString(ConfiguredMapper.mapper().writeValueAsBytes((Object)annotation)) + this.style.endTag();
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Stream<SourceAnnotation> decode(String text) throws IOException {
        int commentStart = text.indexOf(this.style.startTag());
        int commentEnd = text.indexOf(this.style.endTag(), commentStart);
        if (commentStart < 0 || commentEnd < 0) {
            return Stream.empty();
        }
        String encoded = text.substring(commentStart + this.style.startTag().length(), commentEnd);
        byte[] serialized = Base64.getDecoder().decode(encoded);
        return Stream.of((SourceAnnotation)ConfiguredMapper.mapper().readValue(serialized, SourceAnnotation.class));
    }
}

