/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr;

import com.groupcdg.pitest.annotation.SourceAnnotation;
import com.groupcdg.pitest.pr.AnnotationEncoder;
import com.groupcdg.pitest.pr.EncodeStyle;
import com.groupcdg.pitest.pr.GitProviderApi;
import com.groupcdg.pitest.pr.model.Comment;
import com.groupcdg.pitest.pr.model.CommentEntity;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class UploaderWorker {
    private static final Logger LOG = Logger.getGlobal();
    private final AnnotationEncoder encoder;
    private final GitProviderApi api;
    private final boolean deleteOldSummaries;

    public UploaderWorker(GitProviderApi api, boolean deleteOldSummaries, EncodeStyle style) {
        this.api = api;
        this.deleteOldSummaries = deleteOldSummaries;
        this.encoder = new AnnotationEncoder(style);
    }

    public void execute(List<SourceAnnotation> annotations, String summary) {
        try {
            this.updateDiscussions(annotations);
            if (!summary.isEmpty()) {
                this.api.createComment(Comment.topLevel(summary + this.markForFutureDeletion()));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String markForFutureDeletion() {
        if (this.deleteOldSummaries) {
            return "\n" + this.encoder.encode(new SourceAnnotation());
        }
        return "";
    }

    private void updateDiscussions(List<SourceAnnotation> annotations) throws IOException {
        List<CommentEntity> existingComments = this.api.existingComments().stream().filter(this::isPitestDiscussion).collect(Collectors.toList());
        this.resolveDiscussionsWhereMutantsNoLongerExist(annotations, existingComments);
        Set<SourceAnnotation> newMutations = this.findNewMutationsSinceLastRun(annotations, existingComments);
        this.createDiscussionsForNewMutations(newMutations);
    }

    private void createDiscussionsForNewMutations(Collection<SourceAnnotation> annotations) throws IOException {
        List comments = annotations.stream().map(this::toComment).collect(Collectors.toList());
        LOG.info("Creating " + comments.size() + " new comments");
        for (Comment comment : comments) {
            this.api.createComment(comment);
        }
    }

    private Comment toComment(SourceAnnotation annotation) {
        return Comment.annotation(this.makeContent(annotation), annotation.getFile(), annotation.getLine());
    }

    private Set<SourceAnnotation> findNewMutationsSinceLastRun(List<SourceAnnotation> annotations, List<CommentEntity> existingComments) {
        Set existingAnnotations = existingComments.stream().flatMap(this::toSourceAnnotation).collect(Collectors.toSet());
        HashSet<SourceAnnotation> newMutations = new HashSet<SourceAnnotation>(annotations);
        newMutations.removeAll(existingAnnotations);
        return newMutations;
    }

    private void resolveDiscussionsWhereMutantsNoLongerExist(List<SourceAnnotation> annotations, List<CommentEntity> existingComments) throws IOException {
        for (CommentEntity comment : existingComments) {
            Set discusses = this.toSourceAnnotation(comment).collect(Collectors.toSet());
            if (annotations.containsAll(discusses)) continue;
            LOG.info("Deleting stale comment " + comment.id());
            this.api.deleteComment(comment.id());
        }
    }

    private Stream<SourceAnnotation> toSourceAnnotation(CommentEntity comment) {
        try {
            return this.encoder.decode(comment.contents().markdown());
        }
        catch (IOException ex) {
            return Stream.empty();
        }
    }

    private boolean isPitestDiscussion(CommentEntity comment) {
        return AnnotationEncoder.hasEncodedContent(comment.contents().markdown());
    }

    private String makeContent(SourceAnnotation annotation) {
        return "### " + annotation.getTitle() + "\n" + annotation.getMessage() + "\n" + this.encoder.encode(annotation);
    }
}

