/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr.http;

import com.groupcdg.pitest.pr.http.BasicAuthInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SimpleHttpClient {
    private final OkHttpClient client;

    private SimpleHttpClient(OkHttpClient client) {
        this.client = client;
    }

    public static SimpleHttpClient connectWithBasicAuth(String user, String token) {
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new BasicAuthInterceptor(user, token)).build();
        return new SimpleHttpClient(client);
    }

    public int delete(String url) {
        int n;
        block9: {
            Request request = new Request.Builder().url(url).delete().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException(response.body().string());
                }
                n = response.code();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            response.close();
        }
        return n;
    }

    public <T> T get(URI uri, Function<InputStream, T> convert) {
        try {
            return this.get(uri.toURL().toString(), convert);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(String url, Function<InputStream, T> convert) {
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException(response.body().string());
            }
            InputStream t = convert.apply(response.body().byteStream());
            return (T)t;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public int post(String url, String json) {
        int n;
        block9: {
            RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"));
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException(response.body().string());
                }
                n = response.code();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            response.close();
        }
        return n;
    }
}

