/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr.model;

import com.groupcdg.pitest.pr.model.CommentEntity;
import com.groupcdg.pitest.pr.model.CommentId;
import java.util.Optional;

public class Comment {
    private final String markdown;
    private final Integer line;
    private final String path;

    Comment(String markdown, Integer line, String path) {
        this.markdown = markdown;
        this.line = line;
        this.path = path;
    }

    public static Comment topLevel(String markdown) {
        return new Comment(markdown, null, null);
    }

    public static Comment annotation(String markdown, String path, Integer line) {
        return new Comment(markdown, line, path);
    }

    public CommentEntity asEntity(CommentId id) {
        return new CommentEntity(id, this);
    }

    public String markdown() {
        return this.markdown;
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public Integer line() {
        return this.line;
    }

    public String toString() {
        return "Comment{markdown='" + this.markdown + '\'' + ", line=" + this.line + ", path='" + this.path + '\'' + '}';
    }
}

