/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.pr.model;

import java.util.Objects;

public final class CommentId {
    public static final int NO_VERSION = -1;
    private final long id;
    private final int version;

    public CommentId(long id, int version) {
        this.id = id;
        this.version = version;
    }

    public static CommentId unversioned(long id) {
        return new CommentId(id, -1);
    }

    public static CommentId versioned(long id, int version) {
        return new CommentId(id, version);
    }

    public long id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentId commentId = (CommentId)o;
        return this.id == commentId.id && this.version == commentId.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public String toString() {
        if (this.version == -1) {
            return "" + this.id;
        }
        return "" + this.id + " (" + this.version + ")";
    }
}

