/*
 * Decompiled with CFR 0.152.
 */
package com.gu.atom.data;

import cats.Applicative;
import cats.Bifunctor;
import cats.implicits$;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DeleteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.ScanFilter;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.gu.atom.data.AtomDataStore;
import com.gu.atom.data.AtomSerializer$;
import com.gu.atom.data.ClientError;
import com.gu.atom.data.DataStoreError;
import com.gu.atom.data.DataStoreResultUtil;
import com.gu.atom.data.DecoderError;
import com.gu.atom.data.DynamoCompositeKey;
import com.gu.atom.data.DynamoCompositeKey$;
import com.gu.atom.data.DynamoDataStore$CompositeKey$;
import com.gu.atom.data.DynamoError;
import com.gu.atom.data.IDConflictError$;
import com.gu.atom.data.IDNotFound$;
import com.gu.atom.data.ReadError$;
import com.gu.atom.data.VersionConflictError;
import com.gu.atom.util.JsonSupport$;
import com.gu.contentatom.thrift.Atom;
import io.circe.Json;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%h!B\u0012%\u0003\u0003i\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQa\u0014\u0001\u0005\u0002ACq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004]\u0001\u0001\u0006IA\u0016\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019\u0011\u0007\u0001)A\u0005?\"91\r\u0001b\u0001\n\u0013!\u0007B\u00027\u0001A\u0003%QmB\u0003n\u0001!%aNB\u0003q\u0001!%\u0011\u000fC\u0003P\u0017\u0011\u0005!\u000fC\u0004t\u0017\t\u0007I\u0011\u00013\t\rQ\\\u0001\u0015!\u0003f\u0011\u001d)8B1A\u0005\u0002\u0011DaA^\u0006!\u0002\u0013)\u0007\"B<\u0001\t#A\bbBA\f\u0001\u0011E\u0011\u0011\u0004\u0005\b\u0003/\u0001A\u0011CA\u0010\u0011\u001d\ti\u0003\u0001C\t\u0003_Aq!!\u0011\u0001\t#\t\u0019\u0005C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!/\u0001\t\u0003\t\t\rC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002L\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAi\u0001\u0011\u0005\u0011q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t)\u000f\u0001C\u0001\u0003O\u0014q\u0002R=oC6|G)\u0019;b'R|'/\u001a\u0006\u0003K\u0019\nA\u0001Z1uC*\u0011q\u0005K\u0001\u0005CR|WN\u0003\u0002*U\u0005\u0011q-\u001e\u0006\u0002W\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001%\u0013\t9DEA\u0007Bi>lG)\u0019;b'R|'/Z\u0001\u0007Ift\u0017-\\8\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014A\u00033z]\u0006lw\u000e\u001a2we)\u0011ahP\u0001\tg\u0016\u0014h/[2fg*\u0011\u0001IK\u0001\nC6\f'p\u001c8boNL!AQ\u001e\u0003\u001d\u0005k\u0017M_8o\tft\u0017-\\8E\u0005\u0006IA/\u00192mK:\u000bW.\u001a\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d\u0003T\"\u0001%\u000b\u0005%c\u0013A\u0002\u001fs_>$h(\u0003\u0002La\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY\u0005'\u0001\u0004=S:LGO\u0010\u000b\u0004#J\u001b\u0006CA\u001b\u0001\u0011\u0015A4\u00011\u0001:\u0011\u0015\u00195\u00011\u0001E\u0003!!\u0017P\\1n_\u0012\u0013U#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e[\u0014\u0001\u00033pGVlWM\u001c;\n\u0005mC&\u0001\u0003#z]\u0006lw\u000e\u0012\"\u0002\u0013\u0011Lh.Y7p\t\n\u0003\u0013!\u0002;bE2,W#A0\u0011\u0005]\u0003\u0017BA1Y\u0005\u0015!\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005i1+[7qY\u0016\\U-\u001f(b[\u0016,\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA\u0001\\1oO*\t!.\u0001\u0003kCZ\f\u0017BA'h\u00039\u0019\u0016.\u001c9mK.+\u0017PT1nK\u0002\nAbQ8na>\u001c\u0018\u000e^3LKf\u0004\"a\\\u0006\u000e\u0003\u0001\u0011AbQ8na>\u001c\u0018\u000e^3LKf\u001c\"a\u0003\u0018\u0015\u00039\fA\u0002]1si&$\u0018n\u001c8LKf\fQ\u0002]1si&$\u0018n\u001c8LKf\u0004\u0013aB:peR\\U-_\u0001\tg>\u0014HoS3zA\u0005\u0019q-\u001a;\u0015\u0007e\fi\u0001E\u0002puzL!a\u001f?\u0003\u001f\u0011\u000bG/Y*u_J,'+Z:vYRL!! \u0013\u0003'\u0011\u000bG/Y*u_J,'+Z:vYR,F/\u001b7\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0015\u0019\u0017N]2f\u0015\t\t9!\u0001\u0002j_&!\u00111BA\u0001\u0005\u0011Q5o\u001c8\t\u000f\u0005=\u0011\u00031\u0001\u0002\u0012\u0005\u00191.Z=\u0011\u0007U\n\u0019\"C\u0002\u0002\u0016\u0011\u0012!\u0003R=oC6|7i\\7q_NLG/Z&fs\u0006\u0019\u0001/\u001e;\u0015\u0007e\fY\u0002\u0003\u0004\u0002\u001eI\u0001\rA`\u0001\u0005UN|g\u000eF\u0003z\u0003C\t\u0019\u0003\u0003\u0004\u0002\u001eM\u0001\rA \u0005\b\u0003K\u0019\u0002\u0019AA\u0014\u0003!\u0011XM^5tS>t\u0007cA\u0018\u0002*%\u0019\u00111\u0006\u0019\u0003\t1{gnZ\u0001\u0007I\u0016dW\r^3\u0015\t\u0005E\u0012q\b\t\u0005_j\f\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tIdO\u0001\u0006[>$W\r\\\u0005\u0005\u0003{\t9D\u0001\tEK2,G/Z%uK6\u0014Vm];mi\"9\u0011q\u0002\u000bA\u0002\u0005E\u0011\u0001B:dC:,\"!!\u0012\u0011\t=T\u0018q\t\t\u0006\u0003\u0013\n\u0019F \b\u0005\u0003\u0017\nyED\u0002H\u0003\u001bJ\u0011!M\u0005\u0004\u0003#\u0002\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003+\n9F\u0001\u0003MSN$(bAA)a\u0005IQO\\5rk\u0016\\U-\u001f\u000b\u0005\u0003;\n\u0019\u0007E\u0002X\u0003?J1!!\u0019Y\u0005)\u0001&/[7bef\\U-\u001f\u0005\b\u0003K2\u0002\u0019AA\t\u0003I!\u0017P\\1n_\u000e{W\u000e]8tSR,7*Z=\u0002\u0013A\f'o]3Kg>tGcA=\u0002l!1\u0011QN\fA\u0002\u0011\u000b\u0011a]\u0001\u000bUN|g\u000eV8Bi>lG\u0003BA:\u0003\u000b\u0003Ba\u001c>\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014A\u0002;ie&4GOC\u0002\u0002\u0000!\n1bY8oi\u0016tG/\u0019;p[&!\u00111QA=\u0005\u0011\tEo\\7\t\r\u0005u\u0001\u00041\u0001\u007f\u0003)Q7o\u001c8U_&#X-\u001c\u000b\u0005\u0003\u0017\u000b\t\nE\u0002X\u0003\u001bK1!a$Y\u0005\u0011IE/Z7\t\r\u0005u\u0011\u00041\u0001\u007f\u0003=A\u0017M\u001c3mK\u0016C8-\u001a9uS>tG\u0003BAL\u0003_\u0013\u0002\"!'\u0002\u001e\u0006\r\u0016\u0011\u0016\u0004\u0007\u00037\u0003\u0001!a&\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007U\ny*C\u0002\u0002\"\u0012\u0012a\u0002R1uCN#xN]3FeJ|'\u000fE\u00020\u0003KK1!a*1\u0005\u001d\u0001&o\u001c3vGR\u00042aLAV\u0013\r\ti\u000b\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u0003cS\u0002\u0019AAZ\u0003\u0005)\u0007\u0003BA%\u0003kKA!a.\u0002X\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\bO\u0016$\u0018\t^8n)\u0011\t\u0019(!0\t\r\u0005}6\u00041\u0001E\u0003\tIG\r\u0006\u0003\u0002t\u0005\r\u0007bBA39\u0001\u0007\u0011\u0011C\u0001\u000bGJ,\u0017\r^3Bi>lG\u0003BA:\u0003\u0013DaaJ\u000fA\u0002\u0005UDCBA:\u0003\u001b\fy\rC\u0004\u0002fy\u0001\r!!\u0005\t\r\u001dr\u0002\u0019AA;\u0003)!W\r\\3uK\u0006#x.\u001c\u000b\u0005\u0003g\n)\u000e\u0003\u0004\u0002@~\u0001\r\u0001\u0012\u000b\u0005\u0003g\nI\u000eC\u0004\u0002f\u0001\u0002\r!!\u0005\u0002\u0013\u0019Lg\u000eZ!u_6\u001cH\u0003BAp\u0003G\u0004Ba\u001c>\u0002bB1\u0011\u0011JA*\u0003kBQaQ\u0011A\u0002\u0011\u000b\u0011\u0002\\5ti\u0006#x.\\:\u0016\u0005\u0005}\u0007")
public abstract class DynamoDataStore
implements AtomDataStore {
    private volatile DynamoDataStore$CompositeKey$ CompositeKey$module;
    private final String tableName;
    private final DynamoDB dynamoDB;
    private final Table table;
    private final String SimpleKeyName;

    @Override
    public Either<DataStoreError, Nothing$> fail(DataStoreError error) {
        return DataStoreResultUtil.fail$(this, error);
    }

    @Override
    public <R> Either<DataStoreError, R> succeed(Function0<R> result) {
        return DataStoreResultUtil.succeed$(this, result);
    }

    private DynamoDataStore$CompositeKey$ CompositeKey() {
        if (this.CompositeKey$module == null) {
            this.CompositeKey$lzycompute$1();
        }
        return this.CompositeKey$module;
    }

    private DynamoDB dynamoDB() {
        return this.dynamoDB;
    }

    private Table table() {
        return this.table;
    }

    private String SimpleKeyName() {
        return this.SimpleKeyName;
    }

    public Either<DataStoreError, Json> get(DynamoCompositeKey key) {
        Option option;
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Item result = this.table().getItem(this.uniqueKey(key));
            return Option$.MODULE$.apply((Object)result);
        });
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Item item = (Item)some.value();
                return this.parseJson(item.toJSON());
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            return package$.MODULE$.Left().apply((Object)IDNotFound$.MODULE$);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return package$.MODULE$.Left().apply((Object)this.handleException(e));
        }
        throw new MatchError((Object)try_);
    }

    public Either<DataStoreError, Json> put(Json json) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.table().putItem(this.jsonToItem(json)));
        if (try_ instanceof Success) {
            return package$.MODULE$.Right().apply((Object)json);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return package$.MODULE$.Left().apply((Object)this.handleException(e));
        }
        throw new MatchError((Object)try_);
    }

    public Either<DataStoreError, Json> put(Json json, long revision) {
        HashMap<String, Long> expressionAttributeValues = new HashMap<String, Long>();
        expressionAttributeValues.put(":revision", BoxesRunTime.boxToLong((long)revision));
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.table().putItem(this.jsonToItem(json), "contentChangeDetails.revision < :revision", null, (Map)expressionAttributeValues));
        if (try_ instanceof Success) {
            return package$.MODULE$.Right().apply((Object)json);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable conditionError = failure.exception();
            if (conditionError instanceof ConditionalCheckFailedException) {
                return package$.MODULE$.Left().apply((Object)new VersionConflictError(revision));
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            return package$.MODULE$.Left().apply((Object)this.handleException(e));
        }
        throw new MatchError((Object)try_);
    }

    public Either<DataStoreError, DeleteItemResult> delete(DynamoCompositeKey key) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            DynamoCompositeKey dynamoCompositeKey = key;
            if (dynamoCompositeKey != null) {
                String partitionKey = dynamoCompositeKey.partitionKey();
                Option<String> option = dynamoCompositeKey.sortKey();
                if (None$.MODULE$.equals(option)) {
                    return this.table().deleteItem(this.SimpleKeyName(), (Object)partitionKey);
                }
            }
            if (dynamoCompositeKey != null) {
                String partitionKey = dynamoCompositeKey.partitionKey();
                Option<String> option = dynamoCompositeKey.sortKey();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String sortKey = (String)some.value();
                    return this.table().deleteItem(this.CompositeKey().partitionKey(), (Object)partitionKey, this.CompositeKey().sortKey(), (Object)sortKey);
                }
            }
            throw new MatchError((Object)dynamoCompositeKey);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DeleteItemOutcome outcome = (DeleteItemOutcome)success.value();
            return package$.MODULE$.Right().apply((Object)outcome.getDeleteItemResult());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return package$.MODULE$.Left().apply((Object)this.handleException(e));
        }
        throw new MatchError((Object)try_);
    }

    public Either<DataStoreError, List<Json>> scan() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter((Iterator)this.table().scan(new ScanFilter[0]).iterator()).asScala()).toList());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List items = (List)success.value();
            return (Either)implicits$.MODULE$.toTraverseOps((Object)items, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)item -> this.parseJson(item.toJSON()), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return package$.MODULE$.Left().apply((Object)new DynamoError(e.getMessage()));
        }
        throw new MatchError((Object)try_);
    }

    private PrimaryKey uniqueKey(DynamoCompositeKey dynamoCompositeKey) {
        DynamoCompositeKey dynamoCompositeKey2 = dynamoCompositeKey;
        if (dynamoCompositeKey2 != null) {
            String partitionKey = dynamoCompositeKey2.partitionKey();
            Option<String> option = dynamoCompositeKey2.sortKey();
            if (None$.MODULE$.equals(option)) {
                return new PrimaryKey(this.SimpleKeyName(), (Object)partitionKey);
            }
        }
        if (dynamoCompositeKey2 != null) {
            String partitionKey = dynamoCompositeKey2.partitionKey();
            Option<String> option = dynamoCompositeKey2.sortKey();
            if (option instanceof Some) {
                Some some = (Some)option;
                String sortKey = (String)some.value();
                return new PrimaryKey(this.CompositeKey().partitionKey(), (Object)partitionKey, this.CompositeKey().sortKey(), (Object)sortKey);
            }
        }
        throw new MatchError((Object)dynamoCompositeKey2);
    }

    public Either<DataStoreError, Json> parseJson(String s) {
        return (Either)implicits$.MODULE$.toBifunctorOps((Object)io.circe.parser.package$.MODULE$.parse(s), (Bifunctor)implicits$.MODULE$.catsStdBitraverseForEither()).leftMap((Function1 & Serializable & scala.Serializable)parsingFailure -> new DynamoError(parsingFailure.getMessage()));
    }

    public Either<DataStoreError, Atom> jsonToAtom(Json json) {
        return (Either)implicits$.MODULE$.toBifunctorOps((Object)json.as(JsonSupport$.MODULE$.backwardsCompatibleAtomDecoder()), (Bifunctor)implicits$.MODULE$.catsStdBitraverseForEither()).leftMap((Function1 & Serializable & scala.Serializable)error -> new DecoderError(error.message()));
    }

    public Item jsonToItem(Json json) {
        Item item = new Item();
        json.asObject().foreach((Function1 & Serializable & scala.Serializable)obj -> (Iterable)obj.toMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Json value = (Json)tuple2._2();
                return item.withJSON(key, value.noSpaces());
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom()));
        return item;
    }

    private DataStoreError handleException(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof AmazonServiceException) {
            AmazonServiceException amazonServiceException = (AmazonServiceException)throwable;
            return new DynamoError(amazonServiceException.getErrorMessage());
        }
        if (throwable instanceof AmazonClientException) {
            AmazonClientException amazonClientException = (AmazonClientException)throwable;
            return new ClientError(amazonClientException.getMessage());
        }
        return ReadError$.MODULE$;
    }

    @Override
    public Either<DataStoreError, Atom> getAtom(String id) {
        return this.getAtom(new DynamoCompositeKey(id, DynamoCompositeKey$.MODULE$.apply$default$2()));
    }

    @Override
    public Either<DataStoreError, Atom> getAtom(DynamoCompositeKey dynamoCompositeKey) {
        return this.get(dynamoCompositeKey).flatMap((Function1 & Serializable & scala.Serializable)json -> this.jsonToAtom((Json)json));
    }

    @Override
    public Either<DataStoreError, Atom> createAtom(Atom atom) {
        return this.createAtom(new DynamoCompositeKey(atom.id(), DynamoCompositeKey$.MODULE$.apply$default$2()), atom);
    }

    @Override
    public Either<DataStoreError, Atom> createAtom(DynamoCompositeKey dynamoCompositeKey, Atom atom) {
        Either<DataStoreError, Atom> either = this.getAtom(dynamoCompositeKey);
        if (either instanceof Right) {
            return package$.MODULE$.Left().apply((Object)IDConflictError$.MODULE$);
        }
        if (either instanceof Left) {
            return this.put(AtomSerializer$.MODULE$.toJson(atom)).map((Function1 & Serializable & scala.Serializable)x$1 -> atom);
        }
        throw new MatchError(either);
    }

    @Override
    public Either<DataStoreError, Atom> deleteAtom(String id) {
        return this.deleteAtom(new DynamoCompositeKey(id, DynamoCompositeKey$.MODULE$.apply$default$2()));
    }

    @Override
    public Either<DataStoreError, Atom> deleteAtom(DynamoCompositeKey dynamoCompositeKey) {
        return this.getAtom(dynamoCompositeKey).flatMap((Function1 & Serializable & scala.Serializable)atom -> this.delete(dynamoCompositeKey).map((Function1 & Serializable & scala.Serializable)x$2 -> atom));
    }

    private Either<DataStoreError, List<Atom>> findAtoms(String tableName) {
        return this.scan().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Either)implicits$.MODULE$.toTraverseOps(x$3, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)json -> this.jsonToAtom((Json)json), (Applicative)implicits$.MODULE$.catsStdInstancesForEither()));
    }

    @Override
    public Either<DataStoreError, List<Atom>> listAtoms() {
        return this.findAtoms(this.tableName);
    }

    private final void CompositeKey$lzycompute$1() {
        DynamoDataStore dynamoDataStore = this;
        synchronized (dynamoDataStore) {
            if (this.CompositeKey$module == null) {
                this.CompositeKey$module = new DynamoDataStore$CompositeKey$(this);
            }
        }
    }

    public DynamoDataStore(AmazonDynamoDB dynamo, String tableName) {
        this.tableName = tableName;
        DataStoreResultUtil.$init$(this);
        this.dynamoDB = new DynamoDB(dynamo);
        this.table = this.dynamoDB().getTable(tableName);
        this.SimpleKeyName = "id";
    }
}

