/*
 * Decompiled with CFR 0.152.
 */
package com.gu.contentapi.client;

import com.gu.contentapi.client.Constant;
import com.gu.contentapi.client.Constant$;
import com.gu.contentapi.client.Exponential;
import com.gu.contentapi.client.Exponential$;
import com.gu.contentapi.client.Multiple;
import com.gu.contentapi.client.Multiple$;
import java.util.concurrent.TimeUnit;
import scala.Serializable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;

public final class BackoffStrategy$
implements Serializable {
    public static BackoffStrategy$ MODULE$;
    private final int defaultMaxAttempts;
    private final long defaultExponentialMinimumInterval;
    private final long defaultMinimumInterval;
    private final double defaultMinimumMultiplierFactor;

    static {
        new BackoffStrategy$();
    }

    private int defaultMaxAttempts() {
        return this.defaultMaxAttempts;
    }

    private long defaultExponentialMinimumInterval() {
        return this.defaultExponentialMinimumInterval;
    }

    private long defaultMinimumInterval() {
        return this.defaultMinimumInterval;
    }

    private double defaultMinimumMultiplierFactor() {
        return this.defaultMinimumMultiplierFactor;
    }

    public Exponential exponentialStrategy(Duration delay, int maxAttempts) {
        return this.exponential(delay, maxAttempts);
    }

    public Multiple doublingStrategy(Duration delay, int maxAttempts) {
        return this.multiple(delay, maxAttempts, 2.0);
    }

    public Multiple multiplierStrategy(Duration delay, int maxAttempts, double multiplier) {
        return this.multiple(delay, maxAttempts, multiplier);
    }

    public Constant constantStrategy(Duration delay, int maxAttempts) {
        return this.constant(delay, maxAttempts);
    }

    private Exponential exponential(Duration min, int maxAttempts) {
        long ln = Math.max(min.toMillis(), this.defaultExponentialMinimumInterval());
        int mx = maxAttempts > 0 ? maxAttempts : 1;
        return Exponential$.MODULE$.apply((Duration)Duration$.MODULE$.apply(ln, TimeUnit.MILLISECONDS), 0, mx);
    }

    private Duration exponential$default$1() {
        return Duration$.MODULE$.apply(this.defaultExponentialMinimumInterval(), TimeUnit.MILLISECONDS);
    }

    private int exponential$default$2() {
        return this.defaultMaxAttempts();
    }

    private Multiple multiple(Duration min, int maxAttempts, double factor) {
        long ln = Math.max(min.toMillis(), this.defaultMinimumInterval());
        int mx = maxAttempts > 0 ? maxAttempts : 1;
        double fc = factor < this.defaultMinimumMultiplierFactor() ? this.defaultMinimumMultiplierFactor() : factor;
        return Multiple$.MODULE$.apply((Duration)Duration$.MODULE$.apply(ln, TimeUnit.MILLISECONDS), 0, mx, fc);
    }

    private Duration multiple$default$1() {
        return Duration$.MODULE$.apply(this.defaultMinimumInterval(), TimeUnit.MILLISECONDS);
    }

    private int multiple$default$2() {
        return this.defaultMaxAttempts();
    }

    private Constant constant(Duration min, int maxAttempts) {
        long ln = Math.max(min.toMillis(), this.defaultMinimumInterval());
        int mx = maxAttempts > 0 ? maxAttempts : 1;
        return Constant$.MODULE$.apply((Duration)Duration$.MODULE$.apply(ln, TimeUnit.MILLISECONDS), 0, mx);
    }

    private Duration constant$default$1() {
        return Duration$.MODULE$.apply(this.defaultMinimumInterval(), TimeUnit.MILLISECONDS);
    }

    private int constant$default$2() {
        return this.defaultMaxAttempts();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BackoffStrategy$() {
        MODULE$ = this;
        this.defaultMaxAttempts = 3;
        this.defaultExponentialMinimumInterval = 100L;
        this.defaultMinimumInterval = 250L;
        this.defaultMinimumMultiplierFactor = 2.0;
    }
}

