/*
 * Decompiled with CFR 0.152.
 */
package com.gu.facia.api.utils;

import com.gu.contentapi.client.model.v1.CapiDateTime;
import com.gu.contentapi.client.model.v1.Content;
import com.gu.contentapi.client.model.v1.ContentFields;
import com.gu.contentapi.client.model.v1.Element;
import com.gu.contentapi.client.model.v1.Tag;
import com.gu.contentapi.client.model.v1.TagType;
import com.gu.facia.api.models.CuratedContent;
import com.gu.facia.api.models.FaciaContent;
import com.gu.facia.api.models.FaciaImage;
import com.gu.facia.api.models.LatestSnap;
import com.gu.facia.api.models.LinkSnap;
import com.gu.facia.api.models.SupportingCuratedContent;
import com.gu.facia.api.utils.Audio$;
import com.gu.facia.api.utils.CapiModelEnrichment$;
import com.gu.facia.api.utils.CapiModelEnrichment$RichCapiDateTime$;
import com.gu.facia.api.utils.CardStyle;
import com.gu.facia.api.utils.ContentApiUtils$;
import com.gu.facia.api.utils.ContentProperties;
import com.gu.facia.api.utils.DefaultCardstyle$;
import com.gu.facia.api.utils.ExternalLink$;
import com.gu.facia.api.utils.ExternalLinks$;
import com.gu.facia.api.utils.Gallery$;
import com.gu.facia.api.utils.ItemKicker;
import com.gu.facia.api.utils.MediaType;
import com.gu.facia.api.utils.Video$;
import java.io.Serializable;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class FaciaContentUtils$ {
    public static FaciaContentUtils$ MODULE$;
    private final String DefaultSnapHref;

    static {
        new FaciaContentUtils$();
    }

    public <T> T fold(FaciaContent fc, Function1<CuratedContent, T> c, Function1<SupportingCuratedContent, T> scc, Function1<LinkSnap, T> ls, Function1<LatestSnap, T> las) {
        Object object;
        FaciaContent faciaContent = fc;
        if (faciaContent instanceof CuratedContent) {
            CuratedContent curatedContent = (CuratedContent)faciaContent;
            object = c.apply((Object)curatedContent);
        } else if (faciaContent instanceof SupportingCuratedContent) {
            SupportingCuratedContent supportingCuratedContent = (SupportingCuratedContent)faciaContent;
            object = scc.apply((Object)supportingCuratedContent);
        } else if (faciaContent instanceof LinkSnap) {
            LinkSnap linkSnap = (LinkSnap)faciaContent;
            object = ls.apply((Object)linkSnap);
        } else if (faciaContent instanceof LatestSnap) {
            LatestSnap latestSnap = (LatestSnap)faciaContent;
            object = las.apply((Object)latestSnap);
        } else {
            throw new MatchError((Object)faciaContent);
        }
        return (T)object;
    }

    public Option<Content> maybeContent(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> Option$.MODULE$.apply((Object)curatedContent.content()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Option$.MODULE$.apply((Object)supportingCuratedContent.content()), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent());
    }

    public List<Tag> tags(FaciaContent fc) {
        return (List)this.maybeContent(fc).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tags().toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Option<DateTime> webPublicationDateOption(FaciaContent fc) {
        return ((Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.content().webPublicationDate(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.content().webPublicationDate(), (Function1 & Serializable & scala.Serializable)x$2 -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.webPublicationDate()))).map((Function1 & Serializable & scala.Serializable)x$4 -> CapiModelEnrichment$RichCapiDateTime$.MODULE$.toJodaDateTime$extension(CapiModelEnrichment$.MODULE$.RichCapiDateTime((CapiDateTime)x$4)));
    }

    public DateTime webPublicationDate(FaciaContent fc) {
        return (DateTime)this.webPublicationDateOption(fc).getOrElse((Function0 & Serializable & scala.Serializable)() -> DateTime.now());
    }

    public String id(FaciaContent fc) {
        return (String)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.content().id(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.content().id(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.id(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.id());
    }

    public Option<String> maybeContentId(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> Option$.MODULE$.apply((Object)curatedContent.content().id()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Option$.MODULE$.apply((Object)supportingCuratedContent.content().id()), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.id()));
    }

    public String group(FaciaContent fc) {
        return (String)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.group(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.group(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.group(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.group());
    }

    public Option<String> embedType(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.embedType(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)linkSnap -> Option$.MODULE$.apply((Object)linkSnap.snapType()), (Function1 & Serializable & scala.Serializable)latestSnap -> Option$.MODULE$.apply((Object)"latest"));
    }

    public Option<String> embedCss(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.embedCss(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.snapCss(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.snapCss());
    }

    public Option<String> embedUri(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.embedUri(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.snapUri(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.snapUri());
    }

    public Option<ItemKicker> itemKicker(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.kicker(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.kicker(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.kicker(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.kicker());
    }

    public Option<String> headlineOption(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> Option$.MODULE$.apply((Object)curatedContent.headline()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Option$.MODULE$.apply((Object)supportingCuratedContent.headline()), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.headline(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.headline());
    }

    public String headline(FaciaContent fc) {
        return (String)this.headlineOption(fc).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Missing Headline");
    }

    public Option<String> standfirst(FaciaContent fc) {
        return this.fieldsGet(fc, (Function1 & Serializable & scala.Serializable)x$6 -> x$6.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.standfirst()));
    }

    public Option<String> body(FaciaContent fc) {
        return this.fieldsGet(fc, (Function1 & Serializable & scala.Serializable)x$8 -> x$8.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.body()));
    }

    public Option<String> webUrl(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> Option$.MODULE$.apply((Object)curatedContent.content().webUrl()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Option$.MODULE$.apply((Object)supportingCuratedContent.content().webUrl()), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.snapUri(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.webUrl()));
    }

    public String DefaultSnapHref() {
        return this.DefaultSnapHref;
    }

    public Option<String> href(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.href(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.href(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.href().orElse((Function0 & Serializable & scala.Serializable)() -> linkSnap.snapUri()), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.href().orElse((Function0 & Serializable & scala.Serializable)() -> latestSnap.snapUri()));
    }

    public Option<String> atomId(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.atomId(), (Function1 & Serializable & scala.Serializable)latestSnap -> None$.MODULE$);
    }

    public Option<MediaType> mediaType(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> this.mediaTypeFromContent$1(curatedContent.content(), fc), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> this.mediaTypeFromContent$1(supportingCuratedContent.content(), fc), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().flatMap((Function1 & Serializable & scala.Serializable)content -> this.mediaTypeFromContent$1((Content)content, fc)));
    }

    public boolean isLive(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$4(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$7(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$8(latestSnap))));
    }

    private boolean fieldsExists(FaciaContent fc, Function1<Option<ContentFields>, Object> f) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$fieldsExists$1(f, curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$fieldsExists$2(f, supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$fieldsExists$3(x$15)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$fieldsExists$4(f, latestSnap))));
    }

    public boolean isCommentable(FaciaContent fc) {
        return this.fieldsExists(fc, (Function1<Option<ContentFields>, Object>)(Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isCommentable$1(x$16)));
    }

    public Option<CapiDateTime> commentCloseDate(FaciaContent fc) {
        return this.fieldsGet(fc, (Function1 & Serializable & scala.Serializable)x$18 -> x$18.flatMap((Function1 & Serializable & scala.Serializable)x$19 -> x$19.commentCloseDate()));
    }

    private <T> Option<T> fieldsGet(FaciaContent fc, Function1<Option<ContentFields>, Option<T>> f) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> (Option)f.apply((Object)curatedContent.content().fields()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> (Option)f.apply((Object)supportingCuratedContent.content().fields()), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().flatMap((Function1 & Serializable & scala.Serializable)c -> (Option)f.apply((Object)c.fields())));
    }

    public Option<String> maybeShortUrl(FaciaContent fc) {
        return this.fieldsGet(fc, (Function1 & Serializable & scala.Serializable)x$20 -> x$20.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> x$21.shortUrl()));
    }

    public String shortUrl(FaciaContent fc) {
        return (String)this.maybeShortUrl(fc).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> shortUrlPath(FaciaContent fc) {
        return this.maybeShortUrl(fc).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.replaceFirst("^[a-zA-Z]+://gu.com", ""));
    }

    public Option<String> discussionId(FaciaContent fc) {
        return this.shortUrlPath(fc);
    }

    public boolean isBoosted(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isBoosted$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isBoosted$2(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isBoosted$3(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isBoosted$4(latestSnap))));
    }

    public boolean showBoostedHeadline(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showBoostedHeadline$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showBoostedHeadline$2(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showBoostedHeadline$3(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showBoostedHeadline$4(latestSnap))));
    }

    public boolean showQuotedHeadline(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showQuotedHeadline$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showQuotedHeadline$2(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showQuotedHeadline$3(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showQuotedHeadline$4(latestSnap))));
    }

    public boolean showMainVideo(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showMainVideo$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showMainVideo$2(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showMainVideo$3(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showMainVideo$4(latestSnap))));
    }

    public boolean showLivePlayable(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showLivePlayable$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showLivePlayable$2(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showLivePlayable$3(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showLivePlayable$4(latestSnap))));
    }

    public Option<String> sectionName(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.content().sectionName(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.content().sectionName(), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().flatMap((Function1 & Serializable & scala.Serializable)x$23 -> x$23.sectionName()));
    }

    public Option<String> maybeSection(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.content().sectionId(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.content().sectionId(), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().flatMap((Function1 & Serializable & scala.Serializable)x$24 -> x$24.sectionId()));
    }

    public String section(FaciaContent fc) {
        return (String)this.maybeSection(fc).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> byline(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.byline(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.byline(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.byline(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.byline());
    }

    public boolean showByline(FaciaContent fc) {
        return BoxesRunTime.unboxToBoolean(this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showByline$1(curatedContent)), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showByline$2(supportingCuratedContent)), (Function1 & Serializable & scala.Serializable)linkSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showByline$3(linkSnap)), (Function1 & Serializable & scala.Serializable)latestSnap -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$showByline$4(latestSnap))));
    }

    private Seq<Tag> tagsOfType(FaciaContent fc, TagType tagType) {
        return (Seq)this.tags(fc).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$tagsOfType$1(tagType, x$25)));
    }

    public Seq<Tag> nonKeywordTags(FaciaContent fc) {
        return (Seq)this.tags(fc).filterNot((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$nonKeywordTags$1(x$26)));
    }

    public Seq<Tag> keywords(FaciaContent fc) {
        return this.tagsOfType(fc, (TagType)TagType.Keyword$.MODULE$);
    }

    public Seq<Tag> series(FaciaContent fc) {
        return this.tagsOfType(fc, (TagType)TagType.Series$.MODULE$);
    }

    public Seq<Tag> blogs(FaciaContent fc) {
        return this.tagsOfType(fc, (TagType)TagType.Blog$.MODULE$);
    }

    public Seq<Tag> tones(FaciaContent fc) {
        return this.tagsOfType(fc, (TagType)TagType.Tone$.MODULE$);
    }

    public Seq<Tag> types(FaciaContent fc) {
        return this.tagsOfType(fc, (TagType)TagType.Type$.MODULE$);
    }

    public Seq<Tag> contributors(FaciaContent fc) {
        return (Seq)this.maybeContent(fc).map((Function1 & Serializable & scala.Serializable)x$27 -> ContentApiUtils$.MODULE$.RichContent((Content)x$27).contributors()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public boolean isContributorPage(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isContributorPage$1(x$28)));
    }

    public boolean isVideo(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isVideo$1(x$29)));
    }

    public boolean isGallery(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isGallery$1(x$30)));
    }

    public boolean isAudio(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isAudio$1(x$31)));
    }

    public boolean isCartoon(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isCartoon$1(x$32)));
    }

    public boolean isArticle(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isArticle$1(x$33)));
    }

    public boolean isCrossword(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isCrossword$1(x$34)));
    }

    public boolean isLiveBlog(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLiveBlog$1(x$35)));
    }

    public boolean isPodcast(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isPodcast$1(x$36)));
    }

    public boolean isMedia(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isMedia$1(x$37)));
    }

    public boolean isEditorial(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isEditorial$1(x$38)));
    }

    public boolean isComment(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isComment$1(x$39)));
    }

    public boolean isAnalysis(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isAnalysis$1(x$40)));
    }

    public boolean isReview(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isReview$1(x$41)));
    }

    public boolean isLetters(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLetters$1(x$42)));
    }

    public boolean isFeature(FaciaContent fc) {
        return this.maybeContent(fc).exists((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isFeature$1(x$43)));
    }

    public List<FaciaContent> supporting(FaciaContent fc) {
        return (List)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.supportingContent(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Nil$.MODULE$, (Function1 & Serializable & scala.Serializable)linkSnap -> Nil$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> Nil$.MODULE$);
    }

    public Option<Object> starRating(FaciaContent fc) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.fieldsGet(fc, (Function1 & Serializable & scala.Serializable)x$44 -> x$44.flatMap((Function1 & Serializable & scala.Serializable)x$45 -> x$45.starRating()))).toOption().flatten(Predef$.MODULE$.$conforms());
    }

    public Option<String> trailText(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.trailText(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.trailText(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.trailText(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.trailText());
    }

    public Option<Object> wordCount(FaciaContent fc) {
        return this.fieldsGet(fc, (Function1 & Serializable & scala.Serializable)x$46 -> x$46.flatMap((Function1 & Serializable & scala.Serializable)x$47 -> x$47.wordcount()));
    }

    public Option<String> maybeWebTitle(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> Option$.MODULE$.apply((Object)curatedContent.content().webTitle()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Option$.MODULE$.apply((Object)supportingCuratedContent.content().webTitle()), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.latestContent().map((Function1 & Serializable & scala.Serializable)x$48 -> x$48.webTitle()));
    }

    public String webTitle(FaciaContent fc) {
        return (String)this.maybeWebTitle(fc).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> linkText(FaciaContent fc) {
        return this.maybeWebTitle(fc);
    }

    public List<Element> elements(FaciaContent fc) {
        return (List)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> (List)curatedContent.content().elements().map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> (List)supportingCuratedContent.content().elements().map((Function1 & Serializable & scala.Serializable)x$50 -> x$50.toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), (Function1 & Serializable & scala.Serializable)linkSnap -> Nil$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> (List)latestSnap.latestContent().flatMap((Function1 & Serializable & scala.Serializable)x$51 -> x$51.elements().map((Function1 & Serializable & scala.Serializable)x$52 -> x$52.toList())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public CardStyle cardStyle(FaciaContent fc) {
        return (CardStyle)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.cardStyle(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.cardStyle(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.href().exists((Function1 & Serializable & scala.Serializable)url -> BoxesRunTime.boxToBoolean((boolean)ExternalLinks$.MODULE$.external(url))) ? ExternalLink$.MODULE$ : DefaultCardstyle$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.cardStyle());
    }

    public Option<FaciaImage> image(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.image(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.image(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.image(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.image());
    }

    public boolean isClosedForComments(FaciaContent fc) {
        return this.fieldsExists(fc, (Function1<Option<ContentFields>, Object>)(Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isClosedForComments$1(x$53)));
    }

    public Option<ContentProperties> properties(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> Option$.MODULE$.apply((Object)curatedContent.properties()), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> Option$.MODULE$.apply((Object)supportingCuratedContent.properties()), (Function1 & Serializable & scala.Serializable)linkSnap -> None$.MODULE$, (Function1 & Serializable & scala.Serializable)latestSnap -> Option$.MODULE$.apply((Object)latestSnap.properties()));
    }

    public Option<Object> maybeFrontPublicationDate(FaciaContent fc) {
        return (Option)this.fold(fc, (Function1 & Serializable & scala.Serializable)curatedContent -> curatedContent.maybeFrontPublicationDate(), (Function1 & Serializable & scala.Serializable)supportingCuratedContent -> supportingCuratedContent.maybeFrontPublicationDate(), (Function1 & Serializable & scala.Serializable)linkSnap -> linkSnap.maybeFrontPublicationDate(), (Function1 & Serializable & scala.Serializable)latestSnap -> latestSnap.maybeFrontPublicationDate());
    }

    private final Option mediaTypeFromContent$1(Content content, FaciaContent fc$1) {
        return this.isGallery(fc$1) ? Option$.MODULE$.apply((Object)Gallery$.MODULE$) : (this.isAudio(fc$1) ? Option$.MODULE$.apply((Object)Audio$.MODULE$) : (this.isVideo(fc$1) ? Option$.MODULE$.apply((Object)Video$.MODULE$) : None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$1(CuratedContent curatedContent) {
        return curatedContent.content().fields().flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.liveBloggingNow()).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$3(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$6(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$4(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.content().fields().flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.liveBloggingNow()).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$6(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$7(LinkSnap linkSnap) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$isLive$11(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$9(Content x$13) {
        return x$13.fields().flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.liveBloggingNow()).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$11(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public static final /* synthetic */ boolean $anonfun$isLive$8(LatestSnap latestSnap) {
        return latestSnap.latestContent().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isLive$9(x$13)));
    }

    public static final /* synthetic */ boolean $anonfun$fieldsExists$1(Function1 f$1, CuratedContent curatedContent) {
        return BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)curatedContent.content().fields()));
    }

    public static final /* synthetic */ boolean $anonfun$fieldsExists$2(Function1 f$1, SupportingCuratedContent supportingCuratedContent) {
        return BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)supportingCuratedContent.content().fields()));
    }

    public static final /* synthetic */ boolean $anonfun$fieldsExists$3(LinkSnap x$15) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$fieldsExists$5(Function1 f$1, Content c) {
        return BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)c.fields()));
    }

    public static final /* synthetic */ boolean $anonfun$fieldsExists$4(Function1 f$1, LatestSnap latestSnap) {
        return latestSnap.latestContent().exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$fieldsExists$5(f$1, c)));
    }

    public static final /* synthetic */ boolean $anonfun$isCommentable$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean $anonfun$isCommentable$1(Option x$16) {
        return x$16.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.commentable()).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isCommentable$3(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public static final /* synthetic */ boolean $anonfun$isBoosted$1(CuratedContent curatedContent) {
        return curatedContent.properties().isBoosted();
    }

    public static final /* synthetic */ boolean $anonfun$isBoosted$2(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.properties().isBoosted();
    }

    public static final /* synthetic */ boolean $anonfun$isBoosted$3(LinkSnap linkSnap) {
        return linkSnap.properties().isBoosted();
    }

    public static final /* synthetic */ boolean $anonfun$isBoosted$4(LatestSnap latestSnap) {
        return latestSnap.properties().isBoosted();
    }

    public static final /* synthetic */ boolean $anonfun$showBoostedHeadline$1(CuratedContent curatedContent) {
        return curatedContent.properties().showBoostedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showBoostedHeadline$2(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.properties().showBoostedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showBoostedHeadline$3(LinkSnap linkSnap) {
        return linkSnap.properties().showBoostedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showBoostedHeadline$4(LatestSnap latestSnap) {
        return latestSnap.properties().showBoostedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showQuotedHeadline$1(CuratedContent curatedContent) {
        return curatedContent.properties().showQuotedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showQuotedHeadline$2(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.properties().showQuotedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showQuotedHeadline$3(LinkSnap linkSnap) {
        return linkSnap.properties().showQuotedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showQuotedHeadline$4(LatestSnap latestSnap) {
        return latestSnap.properties().showQuotedHeadline();
    }

    public static final /* synthetic */ boolean $anonfun$showMainVideo$1(CuratedContent curatedContent) {
        return curatedContent.properties().showMainVideo();
    }

    public static final /* synthetic */ boolean $anonfun$showMainVideo$2(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.properties().showMainVideo();
    }

    public static final /* synthetic */ boolean $anonfun$showMainVideo$3(LinkSnap linkSnap) {
        return linkSnap.properties().showMainVideo();
    }

    public static final /* synthetic */ boolean $anonfun$showMainVideo$4(LatestSnap latestSnap) {
        return latestSnap.properties().showMainVideo();
    }

    public static final /* synthetic */ boolean $anonfun$showLivePlayable$1(CuratedContent curatedContent) {
        return curatedContent.properties().showLivePlayable();
    }

    public static final /* synthetic */ boolean $anonfun$showLivePlayable$2(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.properties().showLivePlayable();
    }

    public static final /* synthetic */ boolean $anonfun$showLivePlayable$3(LinkSnap linkSnap) {
        return linkSnap.properties().showLivePlayable();
    }

    public static final /* synthetic */ boolean $anonfun$showLivePlayable$4(LatestSnap latestSnap) {
        return latestSnap.properties().showLivePlayable();
    }

    public static final /* synthetic */ boolean $anonfun$showByline$1(CuratedContent curatedContent) {
        return curatedContent.properties().showByline();
    }

    public static final /* synthetic */ boolean $anonfun$showByline$2(SupportingCuratedContent supportingCuratedContent) {
        return supportingCuratedContent.properties().showByline();
    }

    public static final /* synthetic */ boolean $anonfun$showByline$3(LinkSnap linkSnap) {
        return linkSnap.properties().showByline();
    }

    public static final /* synthetic */ boolean $anonfun$showByline$4(LatestSnap latestSnap) {
        return latestSnap.properties().showByline();
    }

    public static final /* synthetic */ boolean $anonfun$tagsOfType$1(TagType tagType$1, Tag x$25) {
        TagType tagType = x$25.type();
        TagType tagType2 = tagType$1;
        return !(tagType != null ? !tagType.equals(tagType2) : tagType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$nonKeywordTags$1(Tag x$26) {
        TagType tagType = x$26.type();
        TagType.Keyword$ keyword$ = TagType.Keyword$.MODULE$;
        return !(tagType != null ? !tagType.equals(keyword$) : keyword$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$isContributorPage$1(Content x$28) {
        return ContentApiUtils$.MODULE$.RichContent(x$28).contributors().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isVideo$1(Content x$29) {
        return ContentApiUtils$.MODULE$.RichContent(x$29).isVideo();
    }

    public static final /* synthetic */ boolean $anonfun$isGallery$1(Content x$30) {
        return ContentApiUtils$.MODULE$.RichContent(x$30).isGallery();
    }

    public static final /* synthetic */ boolean $anonfun$isAudio$1(Content x$31) {
        return ContentApiUtils$.MODULE$.RichContent(x$31).isAudio();
    }

    public static final /* synthetic */ boolean $anonfun$isCartoon$1(Content x$32) {
        return ContentApiUtils$.MODULE$.RichContent(x$32).isCartoon();
    }

    public static final /* synthetic */ boolean $anonfun$isArticle$1(Content x$33) {
        return ContentApiUtils$.MODULE$.RichContent(x$33).isArticle();
    }

    public static final /* synthetic */ boolean $anonfun$isCrossword$1(Content x$34) {
        return ContentApiUtils$.MODULE$.RichContent(x$34).isCrossword();
    }

    public static final /* synthetic */ boolean $anonfun$isLiveBlog$1(Content x$35) {
        return ContentApiUtils$.MODULE$.RichContent(x$35).isLiveBlog();
    }

    public static final /* synthetic */ boolean $anonfun$isPodcast$1(Content x$36) {
        return ContentApiUtils$.MODULE$.RichContent(x$36).isPodcast();
    }

    public static final /* synthetic */ boolean $anonfun$isMedia$1(Content x$37) {
        return ContentApiUtils$.MODULE$.RichContent(x$37).isMedia();
    }

    public static final /* synthetic */ boolean $anonfun$isEditorial$1(Content x$38) {
        return ContentApiUtils$.MODULE$.RichContent(x$38).isEditorial();
    }

    public static final /* synthetic */ boolean $anonfun$isComment$1(Content x$39) {
        return ContentApiUtils$.MODULE$.RichContent(x$39).isComment();
    }

    public static final /* synthetic */ boolean $anonfun$isAnalysis$1(Content x$40) {
        return ContentApiUtils$.MODULE$.RichContent(x$40).isAnalysis();
    }

    public static final /* synthetic */ boolean $anonfun$isReview$1(Content x$41) {
        return ContentApiUtils$.MODULE$.RichContent(x$41).isReview();
    }

    public static final /* synthetic */ boolean $anonfun$isLetters$1(Content x$42) {
        return ContentApiUtils$.MODULE$.RichContent(x$42).isLetters();
    }

    public static final /* synthetic */ boolean $anonfun$isFeature$1(Content x$43) {
        return ContentApiUtils$.MODULE$.RichContent(x$43).isFeature();
    }

    public static final /* synthetic */ boolean $anonfun$isClosedForComments$3(CapiDateTime x$55) {
        return CapiModelEnrichment$RichCapiDateTime$.MODULE$.toJodaDateTime$extension(CapiModelEnrichment$.MODULE$.RichCapiDateTime(x$55)).isAfterNow();
    }

    public static final /* synthetic */ boolean $anonfun$isClosedForComments$1(Option x$53) {
        return !x$53.flatMap((Function1 & Serializable & scala.Serializable)x$54 -> x$54.commentCloseDate()).exists((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)FaciaContentUtils$.$anonfun$isClosedForComments$3(x$55)));
    }

    private FaciaContentUtils$() {
        MODULE$ = this;
        this.DefaultSnapHref = "/";
    }
}

