package com.gu.membership.salesforce

import scala.concurrent.Future
import scala.concurrent.ExecutionContext.Implicits.global

import org.json4s._
import org.json4s.DefaultReaders._

import Member.Keys
import MemberDeserializer._

case class MemberRepositoryError(s: String) extends Throwable {
  override def getMessage: String = s
}

case class MemberId(account: String, contact: String)

abstract class MemberRepository {

  implicit val defaultFormats = DefaultFormats

  val salesforce: Scalaforce

  def upsert(userId: String, values: Map[String, Any]): Future[MemberId] = {
    for {
      result <- salesforce.Contact.upsert(Keys.USER_ID, userId, values)
    } yield {
      val accountId = (result \ Keys.ACCOUNT_ID).as[String]
      val contactId = (result \ Keys.CONTACT_ID).as[String]
      MemberId(accountId, contactId)
    }
  }

  def get(userId: String): Future[Option[Member]] = {
    for {
      result <- salesforce.Contact.read(Keys.USER_ID, userId)
    } yield result.map(_.as[Member])
  }
}
