package com.gu.membership.util

import com.gu.monitoring.CloudWatch
import com.typesafe.scalalogging.slf4j.LazyLogging

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future


object Timing extends LazyLogging {

  def record[T](cloudWatch: CloudWatch, metricName: String)(block: => Future[T]): Future[T] = {
    logger.trace(s"$metricName started...")
    cloudWatch.put(metricName, 1)
    val startTime = System.currentTimeMillis()
    val fut = block
    fut.foreach {
      t=>
        val endTime = System.currentTimeMillis()
        val duration = endTime - startTime

        cloudWatch.put(metricName+" duration ms", duration)

        logger.debug(s"${cloudWatch.service} $metricName completed in $duration ms")
    }
    fut
  }
}
