package com.gu.membership.zuora

case class Address(lineOne: String, lineTwo: String, town: String, countyOrState: String,
                   postCode: String, country: Country) {
  // Salesforce only has one address line field, so merge our two together
  val line = Seq(lineOne, lineTwo).filter(_.nonEmpty).mkString(", ")

  lazy val valid = country.validate(this)
}

object AddressValidators {
  def requirePostcode(address: Address): Boolean = address.postCode.nonEmpty

  def requireStateAndPostcode(address: Address): Boolean =
    requirePostcode(address) && address.country.states.contains(address.countyOrState)

  def requireLineOneAndTown(address: Address): Boolean = address.lineOne.nonEmpty && address.town.nonEmpty
}
