package ophan

import java.nio.ByteBuffer

import com.twitter.scrooge.ThriftStruct

trait ThriftPimps {
  implicit class ThiftStructPimp(t: ThriftStruct) {
    def getBytes: Array[Byte] = ThriftSerializer.asThriftEncodedBytes(t)
    def getByteBuffer: ByteBuffer = ByteBuffer.wrap(getBytes)
  }

  /*

  So I wanted to pimp this onto the campainion objects allowing
  val e: Event = Event.decode(bytes)
  but this doesn't work because ts ends up being Event.type, not the Event companion object.

  For now, call ThriftSerializer.inputProtocolFrom directly.

  implicit class ThriftStructCompanionPimp[T <: ThriftStruct, S <: ThriftStructCodec3[T]](ts: S) {
    def decode(bytes: Array[Byte])= ts.decode(ThriftSerializer.inputProtocolFrom(bytes))
    def decodeByteBuffer(byteBuffer: ByteBuffer) = ts.decode(ThriftSerializer.inputProtocolFrom(byteBuffer))
  }

   */

}

object ThriftPimps extends ThriftPimps
