package ophan

import com.twitter.scrooge.ThriftStruct
import org.apache.thrift.protocol.{TCompactProtocol, TProtocol}
import org.apache.thrift.transport.{TByteBuffer, TIOStreamTransport, TMemoryInputTransport}

import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer


// Some basic helpers for doing thrift serialisation. You'll probably
// find it easier to use ThriftPimps instead though.
object ThriftSerializer {
  private val protocolFactory = new TCompactProtocol.Factory()
  
  def inputProtocolFrom(byteBuffer: ByteBuffer): TProtocol = {
    protocolFactory.getProtocol(new TByteBuffer(byteBuffer))
  }

  def inputProtocolFrom(bytes: Array[Byte]): TProtocol =
    protocolFactory.getProtocol(new TMemoryInputTransport(bytes))

  def fromByteBuffer[T <: ThriftStruct](byteBuffer: ByteBuffer)(decoder: TProtocol => T): T =
    decoder(inputProtocolFrom(byteBuffer))

  def fromByteArray[T <: ThriftStruct](bytes: Array[Byte])(decoder: TProtocol => T): T =
    decoder(inputProtocolFrom(bytes))

  def asThriftEncodedBytes[T <: ThriftStruct](thriftObject: T, initialBufferSizeHint: Int = 2000): Array[Byte] = {
    val byteArrayOutputStream = new ByteArrayOutputStream(initialBufferSizeHint)
    val writer = new TIOStreamTransport(byteArrayOutputStream)
    val proto = protocolFactory.getProtocol(writer)

    thriftObject.write(proto)

    writer.flush()

    byteArrayOutputStream.toByteArray
  }
}
