/**
 * Generated by Scrooge
 *   version: 21.6.0
 *   rev: 94297159b516fc8e4ffb3d2552aeee4e1c904731
 *   built at: 20210622-155759
 */
package ophan.thrift.device

import com.twitter.scrooge.ThriftEnum
import scala.collection.immutable.{Map => immutable$Map}

/**
 * This class is designed to match the DeviceClass returned from our user agent parsing library yauaa
 * (see https://github.com/nielsbasjes/yauaa/blob/0fb59d61f5de6d9e77d7e78e1c5b153bdc6ed2aa/analyzer/src/main/java/nl/basjes/parse/useragent/classify/DeviceClass.java#L20).
 * Values added to this class should reflect what is in the yauaa class, we should not pollute it with values which do not
 * represent devices like the GUARDIAN_ANDROID_NATIVE_APP found in ua.thrift
 */
@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
object DeviceClass extends _root_.com.twitter.scrooge.ThriftEnumObject[DeviceClass] {

  val annotations: immutable$Map[String, String] = immutable$Map.empty

  /**
     * The device is assessed as a Desktop/Laptop class device.
     */
  case object Desktop extends ophan.thrift.device.DeviceClass {
    val value: Int = 1
    val name: String = "Desktop"
    val originalName: String = "DESKTOP"
    val annotations: immutable$Map[String, String] = immutable$Map.empty
  }

  private[this] val _SomeDesktop: _root_.scala.Some[ophan.thrift.device.DeviceClass] = _root_.scala.Some(ophan.thrift.device.DeviceClass.Desktop)
  /**
     * In some cases the useragent has been altered by anonimization software.
     */
  case object Anonymized extends ophan.thrift.device.DeviceClass {
    val value: Int = 2
    val name: String = "Anonymized"
    val originalName: String = "ANONYMIZED"
    val annotations: immutable$Map[String, String] = immutable$Map.empty
  }

  private[this] val _SomeAnonymized: _root_.scala.Some[ophan.thrift.device.DeviceClass] = _root_.scala.Some(ophan.thrift.device.DeviceClass.Anonymized)
  /**
     * A device that is mobile yet we do not know if it is a eReader/Tablet/Phone or Watch.
     */
  case object Mobile extends ophan.thrift.device.DeviceClass {
    val value: Int = 3
    val name: String = "Mobile"
    val originalName: String = "MOBILE"
    val annotations: immutable$Map[String, String] = immutable$Map.empty
  }

  private[this] val _SomeMobile: _root_.scala.Some[ophan.thrift.device.DeviceClass] = _root_.scala.Some(ophan.thrift.device.DeviceClass.Mobile)
  /**
     * A mobile device with a rather large screen (common &gt; 7").
     */
  case object Tablet extends ophan.thrift.device.DeviceClass {
    val value: Int = 4
    val name: String = "Tablet"
    val originalName: String = "TABLET"
    val annotations: immutable$Map[String, String] = immutable$Map.empty
  }

  private[this] val _SomeTablet: _root_.scala.Some[ophan.thrift.device.DeviceClass] = _root_.scala.Some(ophan.thrift.device.DeviceClass.Tablet)
  /**
     * A mobile device with a small screen (common &lt; 7").
     */
  case object Phone extends ophan.thrift.device.DeviceClass {
    val value: Int = 5
    val name: String = "Phone"
    val originalName: String = "PHONE"
    val annotations: immutable$Map[String, String] = immutable$Map.empty
  }

  private[this] val _SomePhone: _root_.scala.Some[ophan.thrift.device.DeviceClass] = _root_.scala.Some(ophan.thrift.device.DeviceClass.Phone)

  case class EnumUnknownDeviceClass(value: Int)
    extends ophan.thrift.device.DeviceClass with _root_.com.twitter.scrooge.EnumItemUnknown
  {
    val name: String = "EnumUnknownDeviceClass" + value
    def originalName: String = name
    val annotations: immutable$Map[String, String] = immutable$Map.empty
  }

  /**
   * Find the enum by its integer value, as defined in the Thrift IDL.
   */
  def apply(value: Int): ophan.thrift.device.DeviceClass = {
    val enumOpt = get(value)
    if (enumOpt.isDefined) {
      enumOpt.get
    } else {
      throw new NoSuchElementException(_root_.java.lang.Integer.toString(value))
    }
  }

  /**
   * Find the enum by its integer value, as defined in the Thrift IDL.
   * returns an EnumUnknownDeviceClass(value) if the value is not found.
   * In particular this allows ignoring new values added to an enum
   * in the IDL on the producer side when the consumer was not updated.
   */
  def getOrUnknown(value: Int): ophan.thrift.device.DeviceClass = {
    val enumOpt = get(value)
    if (enumOpt.isDefined) {
      enumOpt.get
    } else {
      EnumUnknownDeviceClass(value)
    }
  }

  /**
   * Find the enum by its integer value, as defined in the Thrift IDL.
   * Returns None if the value is not found
   */
  def get(value: Int): _root_.scala.Option[ophan.thrift.device.DeviceClass] =
    value match {
      case 1 => _SomeDesktop
      case 2 => _SomeAnonymized
      case 3 => _SomeMobile
      case 4 => _SomeTablet
      case 5 => _SomePhone
      case _ => _root_.scala.None
    }

  def valueOf(name: String): _root_.scala.Option[ophan.thrift.device.DeviceClass] =
    name.toLowerCase match {
      case "desktop" => _SomeDesktop
      case "anonymized" => _SomeAnonymized
      case "mobile" => _SomeMobile
      case "tablet" => _SomeTablet
      case "phone" => _SomePhone
      case _ => _root_.scala.None
    }

  lazy val list: List[ophan.thrift.device.DeviceClass] = scala.List[ophan.thrift.device.DeviceClass](
    ophan.thrift.device.DeviceClass.Desktop,
    ophan.thrift.device.DeviceClass.Anonymized,
    ophan.thrift.device.DeviceClass.Mobile,
    ophan.thrift.device.DeviceClass.Tablet,
    ophan.thrift.device.DeviceClass.Phone
  )

  lazy val unsafeEmpty: ophan.thrift.device.DeviceClass =
    EnumUnknownDeviceClass(0)
}


/**
 * This class is designed to match the DeviceClass returned from our user agent parsing library yauaa
 * (see https://github.com/nielsbasjes/yauaa/blob/0fb59d61f5de6d9e77d7e78e1c5b153bdc6ed2aa/analyzer/src/main/java/nl/basjes/parse/useragent/classify/DeviceClass.java#L20).
 * Values added to this class should reflect what is in the yauaa class, we should not pollute it with values which do not
 * represent devices like the GUARDIAN_ANDROID_NATIVE_APP found in ua.thrift
 */
@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
sealed trait DeviceClass extends ThriftEnum with Serializable