/**
 * Generated by Scrooge
 *   version: 21.6.0
 *   rev: 94297159b516fc8e4ffb3d2552aeee4e1c904731
 *   built at: 20210622-155759
 */
package ophan.thrift.event

import com.twitter.io.Buf
import com.twitter.scrooge.{
  InvalidFieldsException,
  LazyTProtocol,
  StructBuilder,
  StructBuilderFactory,
  TFieldBlob,
  ThriftStruct,
  ThriftStructCodec3,
  ThriftStructField,
  ThriftStructFieldInfo,
  ThriftStructMetaData,
  ValidatingThriftStruct,
  ValidatingThriftStructCodec3
}
import org.apache.thrift.protocol._
import org.apache.thrift.transport.TMemoryBuffer
import scala.collection.immutable.{Map => immutable$Map}
import scala.collection.mutable.Builder
import scala.reflect.{ClassTag, classTag}

/**
* Details about media playback progress
* Note: currently only guardian-hosted videos are reported.
**/
object MediaPlayback extends ValidatingThriftStructCodec3[MediaPlayback] with StructBuilderFactory[MediaPlayback] {
  private[this] val _protos: _root_.com.twitter.scrooge.internal.TProtocols = _root_.com.twitter.scrooge.internal.TProtocols()

  val Struct: TStruct = new TStruct("MediaPlayback")
  val MediaIdField: TField = new TField("mediaId", TType.STRING, 1)
  val MediaIdFieldManifest: Manifest[String] = manifest[String]
  val MediaTypeField: TField = new TField("mediaType", TType.ENUM, 2)
  val MediaTypeFieldI32: TField = new TField("mediaType", TType.I32, 2)
  val MediaTypeFieldManifest: Manifest[ophan.thrift.event.MediaType] = manifest[ophan.thrift.event.MediaType]
  val PrerollField: TField = new TField("preroll", TType.BOOL, 3)
  val PrerollFieldManifest: Manifest[Boolean] = manifest[Boolean]
  val EventTypeField: TField = new TField("eventType", TType.ENUM, 4)
  val EventTypeFieldI32: TField = new TField("eventType", TType.I32, 4)
  val EventTypeFieldManifest: Manifest[ophan.thrift.event.MediaEvent] = manifest[ophan.thrift.event.MediaEvent]

  /**
   * Field information in declaration order.
   */
  lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
    new ThriftStructFieldInfo(
      MediaIdField,
      false,
      true,
      MediaIdFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      MediaTypeField,
      false,
      true,
      MediaTypeFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.event.MediaType.unsafeEmpty)
    ),
    new ThriftStructFieldInfo(
      PrerollField,
      false,
      true,
      PrerollFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(false)
    ),
    new ThriftStructFieldInfo(
      EventTypeField,
      false,
      true,
      EventTypeFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.event.MediaEvent.unsafeEmpty)
    )
  )


  val structAnnotations: immutable$Map[String, String] =
    immutable$Map.empty[String, String]

  private val fieldTypes: IndexedSeq[ClassTag[_]] = IndexedSeq[ClassTag[_]](
    classTag[String].asInstanceOf[ClassTag[_]],
    classTag[ophan.thrift.event.MediaType].asInstanceOf[ClassTag[_]],
    classTag[Boolean].asInstanceOf[ClassTag[_]],
    classTag[ophan.thrift.event.MediaEvent].asInstanceOf[ClassTag[_]]
  )

  private[this] val structFields: Seq[ThriftStructField[MediaPlayback]] = Seq[ThriftStructField[MediaPlayback]](
    new ThriftStructField[MediaPlayback](
      MediaIdField,
      _root_.scala.Some(MediaIdFieldManifest),
      classOf[MediaPlayback]) {
        def getValue[R](struct: MediaPlayback): R = struct.mediaId.asInstanceOf[R]
    },
    new ThriftStructField[MediaPlayback](
      MediaTypeField,
      _root_.scala.Some(MediaTypeFieldManifest),
      classOf[MediaPlayback]) {
        def getValue[R](struct: MediaPlayback): R = struct.mediaType.asInstanceOf[R]
    },
    new ThriftStructField[MediaPlayback](
      PrerollField,
      _root_.scala.Some(PrerollFieldManifest),
      classOf[MediaPlayback]) {
        def getValue[R](struct: MediaPlayback): R = struct.preroll.asInstanceOf[R]
    },
    new ThriftStructField[MediaPlayback](
      EventTypeField,
      _root_.scala.Some(EventTypeFieldManifest),
      classOf[MediaPlayback]) {
        def getValue[R](struct: MediaPlayback): R = struct.eventType.asInstanceOf[R]
    }
  )

  override lazy val metaData: ThriftStructMetaData[MediaPlayback] =
    ThriftStructMetaData(this, structFields, fieldInfos, Nil, structAnnotations)

  /**
   * Checks that all required fields are non-null.
   */
  def validate(_item: MediaPlayback): Unit = {
    if (_item.mediaId eq null) throw new TProtocolException("Required field mediaId cannot be null")
    if (_item.mediaType eq null) throw new TProtocolException("Required field mediaType cannot be null")
    if (_item.eventType eq null) throw new TProtocolException("Required field eventType cannot be null")
  }

  /**
   * Checks that the struct is a valid as a new instance. If there are any missing required or
   * construction required fields, return a non-empty list.
   */
  def validateNewInstance(item: MediaPlayback): scala.Seq[com.twitter.scrooge.validation.Issue] = {
    val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]

    if (item.mediaId eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(0))
    buf ++= validateField(item.mediaId)
    if (item.mediaType eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(1))
    buf ++= validateField(item.mediaType)
    buf ++= validateField(item.preroll)
    if (item.eventType eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(3))
    buf ++= validateField(item.eventType)
    buf.toList
  }

  def withoutPassthroughFields(original: MediaPlayback): MediaPlayback =
    new Immutable(
      mediaId = original.mediaId,
      mediaType = original.mediaType,
      preroll = original.preroll,
      eventType = original.eventType
    )

  lazy val unsafeEmpty: MediaPlayback = {
    val mediaId: String = "empty"
    val mediaType: ophan.thrift.event.MediaType = ophan.thrift.event.MediaType.unsafeEmpty
    val preroll: Boolean = false
    val eventType: ophan.thrift.event.MediaEvent = ophan.thrift.event.MediaEvent.unsafeEmpty

    new Immutable(
      mediaId,
      mediaType,
      preroll,
      eventType,
      _root_.com.twitter.scrooge.internal.TProtocols.NoPassthroughFields
    )
  }

  def newBuilder(): StructBuilder[MediaPlayback] = new MediaPlaybackStructBuilder(_root_.scala.None, fieldTypes)

  override def encode(_item: MediaPlayback, _oproto: TProtocol): Unit = {
    _item.write(_oproto)
  }


  override def decode(_iprot: TProtocol): MediaPlayback = {
    if (_iprot.isInstanceOf[LazyTProtocol]) {
      decodeInternal(_iprot, true)
    } else {
      decodeInternal(_iprot, false)
    }
  }

  private[event] def eagerDecode(_iprot: TProtocol): MediaPlayback = {
    decodeInternal(_iprot, false)
  }

  private[this] def decodeInternal(_iprot: TProtocol, lazily: Boolean): MediaPlayback = {
    var mediaIdOffset: Int = -1
    var mediaId: String = null
    var _got_mediaId = false
    var mediaType: ophan.thrift.event.MediaType = null
    var _got_mediaType = false
    var preroll: Boolean = false
    var _got_preroll = false
    var eventType: ophan.thrift.event.MediaEvent = null
    var _got_eventType = false

    var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
    var _done = false
    val _start_offset = if (lazily) _iprot.asInstanceOf[LazyTProtocol].offset else -1

    _iprot.readStructBegin()
    do {
      val _field = _iprot.readFieldBegin()
      val _fieldType = _field.`type`
      if (_fieldType == TType.STOP) {
        _done = true
      } else {
        _field.id match {
          case 1 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "mediaId")
            if (lazily)
              mediaIdOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              mediaId = _iprot.readString()
            _got_mediaId = true
          case 2 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateEnumFieldType(_fieldType, "mediaType")
            mediaType = ophan.thrift.event.MediaType.getOrUnknown(_iprot.readI32())
            _got_mediaType = true
          case 3 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.BOOL, _fieldType, "preroll")
            preroll = _iprot.readBool()
            _got_preroll = true
          case 4 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateEnumFieldType(_fieldType, "eventType")
            eventType = ophan.thrift.event.MediaEvent.getOrUnknown(_iprot.readI32())
            _got_eventType = true
          case _ =>
            _passthroughFields = _root_.com.twitter.scrooge.internal.TProtocols.readPassthroughField(_iprot, _field, _passthroughFields)
        }
        _iprot.readFieldEnd()
      }
    } while (!_done)
    _iprot.readStructEnd()

    if (!_got_mediaId) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("MediaPlayback", "mediaId")
    if (!_got_mediaType) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("MediaPlayback", "mediaType")
    if (!_got_preroll) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("MediaPlayback", "preroll")
    if (!_got_eventType) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("MediaPlayback", "eventType")

    val _passthroughFieldsResult =
      if (_passthroughFields eq null) _root_.com.twitter.scrooge.internal.TProtocols.NoPassthroughFields
      else _passthroughFields.result()
    if (lazily) {
      val _lazyProt = _iprot.asInstanceOf[LazyTProtocol]
      new LazyImmutable(
        _lazyProt,
        _lazyProt.buffer,
        _start_offset,
        _lazyProt.offset,
        mediaIdOffset,
        mediaType,
        preroll,
        eventType,
        _passthroughFieldsResult
      )
    } else {
      new Immutable(
        mediaId,
        mediaType,
        preroll,
        eventType,
        _passthroughFieldsResult
      )
    }
  }

  def apply(
    mediaId: String,
    mediaType: ophan.thrift.event.MediaType,
    preroll: Boolean,
    eventType: ophan.thrift.event.MediaEvent
  ): MediaPlayback =
    new Immutable(
      mediaId,
      mediaType,
      preroll,
      eventType
    )

  def unapply(_item: MediaPlayback): _root_.scala.Option[_root_.scala.Tuple4[String, ophan.thrift.event.MediaType, Boolean, ophan.thrift.event.MediaEvent]] = _root_.scala.Some(_item.toTuple)



  object Immutable extends ThriftStructCodec3[MediaPlayback] {
    override def encode(_item: MediaPlayback, _oproto: TProtocol): Unit = { _item.write(_oproto) }
    override def decode(_iprot: TProtocol): MediaPlayback = MediaPlayback.decode(_iprot)
    override lazy val metaData: ThriftStructMetaData[MediaPlayback] = MediaPlayback.metaData
  }

  /**
   * The default read-only implementation of MediaPlayback.  You typically should not need to
   * directly reference this class; instead, use the MediaPlayback.apply method to construct
   * new instances.
   */
  class Immutable(
      val mediaId: String,
      val mediaType: ophan.thrift.event.MediaType,
      val preroll: Boolean,
      val eventType: ophan.thrift.event.MediaEvent,
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends MediaPlayback {
    def this(
      mediaId: String,
      mediaType: ophan.thrift.event.MediaType,
      preroll: Boolean,
      eventType: ophan.thrift.event.MediaEvent
    ) = this(
      mediaId,
      mediaType,
      preroll,
      eventType,
      immutable$Map.empty[Short, TFieldBlob]
    )
  }

  /**
   * This is another Immutable, this however keeps strings as lazy values that are lazily decoded from the backing
   * array byte on read.
   */
  private[this] class LazyImmutable(
      _proto: LazyTProtocol,
      _buf: Array[Byte],
      _start_offset: Int,
      _end_offset: Int,
      mediaIdOffset: Int,
      val mediaType: ophan.thrift.event.MediaType,
      val preroll: Boolean,
      val eventType: ophan.thrift.event.MediaEvent,
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends MediaPlayback {

    override def write(_oprot: TProtocol): Unit = {
      if (_oprot.isInstanceOf[LazyTProtocol]) {
        _oprot.asInstanceOf[LazyTProtocol].writeRaw(_buf, _start_offset, _end_offset - _start_offset)
      } else {
        super.write(_oprot)
      }
    }

    lazy val mediaId: String =
      if (mediaIdOffset == -1)
        null
      else {
        _proto.decodeString(_buf, mediaIdOffset)
      }

    /**
     * Override the super hash code to make it a lazy val rather than def.
     *
     * Calculating the hash code can be expensive, caching it where possible
     * can provide significant performance wins. (Key in a hash map for instance)
     * Usually not safe since the normal constructor will accept a mutable map or
     * set as an arg
     * Here however we control how the class is generated from serialized data.
     * With the class private and the contract that we throw away our mutable references
     * having the hash code lazy here is safe.
     */
    override lazy val hashCode: Int = super.hashCode
  }

}

/**
 * Prefer the companion object's [[ophan.thrift.event.MediaPlayback.apply]]
 * for construction if you don't need to specify passthrough fields.
 */
trait MediaPlayback
  extends ThriftStruct
  with _root_.scala.Product4[String, ophan.thrift.event.MediaType, Boolean, ophan.thrift.event.MediaEvent]
  with ValidatingThriftStruct[MediaPlayback]
  with java.io.Serializable
{
  import MediaPlayback._

  /**
  * The id of the media asset, e.g. gu-video-454297906
  * This matches up with the media id within the content api.
  **/
  def mediaId: String
  /**
  * The media type
  **/
  def mediaType: ophan.thrift.event.MediaType
  /**
  * If true, this event relates to the pre-roll (ad) of this media.
  * If false, this event reated to the core media content.
  **/
  def preroll: Boolean
  /**
  * The event type.
  **/
  def eventType: ophan.thrift.event.MediaEvent

  def _passthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty

  def _1: String = mediaId
  def _2: ophan.thrift.event.MediaType = mediaType
  def _3: Boolean = preroll
  def _4: ophan.thrift.event.MediaEvent = eventType

  def toTuple: _root_.scala.Tuple4[String, ophan.thrift.event.MediaType, Boolean, ophan.thrift.event.MediaEvent] =
    _root_.scala.Tuple4[String, ophan.thrift.event.MediaType, Boolean, ophan.thrift.event.MediaEvent](
      mediaId,
      mediaType,
      preroll,
      eventType
    )


  /**
   * Gets a field value encoded as a binary blob using TCompactProtocol.  If the specified field
   * is present in the passthrough map, that value is returned.  Otherwise, if the specified field
   * is known and not optional and set to None, then the field is serialized and returned.
   */
  def getFieldBlob(_fieldId: Short): _root_.scala.Option[TFieldBlob] = {
    val passedthroughValue = _passthroughFields.get(_fieldId)
    if (passedthroughValue.isDefined) {
      passedthroughValue
    } else {
      val _protos = _root_.com.twitter.scrooge.internal.TProtocols()
      val _buff = new TMemoryBuffer(32)
      val _oprot = new TCompactProtocol(_buff)

      val _fieldOpt: _root_.scala.Option[TField] = _fieldId match {
        case 1 =>
          if (mediaId ne null) {
            _oprot.writeString(mediaId)
            _root_.scala.Some(MediaPlayback.MediaIdField)
          } else {
            _root_.scala.None
          }
        case 2 =>
          if (mediaType ne null) {
            _oprot.writeI32(mediaType.value)
            _root_.scala.Some(MediaPlayback.MediaTypeField)
          } else {
            _root_.scala.None
          }
        case 3 =>
            _oprot.writeBool(preroll)
            _root_.scala.Some(MediaPlayback.PrerollField)
        case 4 =>
          if (eventType ne null) {
            _oprot.writeI32(eventType.value)
            _root_.scala.Some(MediaPlayback.EventTypeField)
          } else {
            _root_.scala.None
          }
        case _ => _root_.scala.None
      }
      if (_fieldOpt.isDefined) {
        _root_.scala.Some(TFieldBlob(_fieldOpt.get, Buf.ByteArray.Owned(_buff.getArray)))
      } else {
        _root_.scala.None
      }
    }
  }


  /**
   * Collects TCompactProtocol-encoded field values according to `getFieldBlob` into a map.
   */
  def getFieldBlobs(ids: TraversableOnce[Short]): immutable$Map[Short, TFieldBlob] =
    (ids.flatMap { id => getFieldBlob(id).map { fieldBlob => (id, fieldBlob) } }).toMap

  /**
   * Sets a field using a TCompactProtocol-encoded binary blob.  If the field is a known
   * field, the blob is decoded and the field is set to the decoded value.  If the field
   * is unknown and passthrough fields are enabled, then the blob will be stored in
   * _passthroughFields.
   */
  def setField(_blob: TFieldBlob): MediaPlayback = {
    val _protos: _root_.com.twitter.scrooge.internal.TProtocols = _root_.com.twitter.scrooge.internal.TProtocols()
    var mediaId: String = this.mediaId
    var mediaType: ophan.thrift.event.MediaType = this.mediaType
    var preroll: Boolean = this.preroll
    var eventType: ophan.thrift.event.MediaEvent = this.eventType
    var _passthroughFields = this._passthroughFields
    val _iprot = _blob.read 
    _blob.id match {
      case 1 =>
        mediaId = _iprot.readString()
      case 2 =>
        mediaType = ophan.thrift.event.MediaType.getOrUnknown(_iprot.readI32())
      case 3 =>
        preroll = _iprot.readBool()
      case 4 =>
        eventType = ophan.thrift.event.MediaEvent.getOrUnknown(_iprot.readI32())
      case _ => _passthroughFields += _root_.scala.Tuple2(_blob.id, _blob)
    }
    new Immutable(
      mediaId,
      mediaType,
      preroll,
      eventType,
      _passthroughFields
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetField(_fieldId: Short): MediaPlayback = {
    var mediaId: String = this.mediaId
    var mediaType: ophan.thrift.event.MediaType = this.mediaType
    var preroll: Boolean = this.preroll
    var eventType: ophan.thrift.event.MediaEvent = this.eventType

    _fieldId match {
      case 1 =>
        mediaId = null
      case 2 =>
        mediaType = null
      case 3 =>
        preroll = false
      case 4 =>
        eventType = null
      case _ =>
    }
    new Immutable(
      mediaId,
      mediaType,
      preroll,
      eventType,
      _passthroughFields - _fieldId
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetMediaId: MediaPlayback = unsetField(1)

  def unsetMediaType: MediaPlayback = unsetField(2)

  def unsetPreroll: MediaPlayback = unsetField(3)

  def unsetEventType: MediaPlayback = unsetField(4)


  override def write(_oprot: TProtocol): Unit = {
    MediaPlayback.validate(this)
    val _protos = _root_.com.twitter.scrooge.internal.TProtocols()
    _oprot.writeStructBegin(Struct)
    if (mediaId ne null) {
      _oprot.writeFieldBegin(MediaIdField)
      _oprot.writeString(mediaId)
      _oprot.writeFieldEnd()
    }
    if (mediaType ne null) {
      _oprot.writeFieldBegin(MediaTypeFieldI32)
      _oprot.writeI32(mediaType.value)
      _oprot.writeFieldEnd()
    }
    _oprot.writeFieldBegin(PrerollField)
    _oprot.writeBool(preroll)
    _oprot.writeFieldEnd()
    if (eventType ne null) {
      _oprot.writeFieldBegin(EventTypeFieldI32)
      _oprot.writeI32(eventType.value)
      _oprot.writeFieldEnd()
    }
    _root_.com.twitter.scrooge.internal.TProtocols.finishWritingStruct(_oprot, _passthroughFields)
  }

  def copy(
    mediaId: String = this.mediaId,
    mediaType: ophan.thrift.event.MediaType = this.mediaType,
    preroll: Boolean = this.preroll,
    eventType: ophan.thrift.event.MediaEvent = this.eventType,
    _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
  ): MediaPlayback =
    new Immutable(
      mediaId,
      mediaType,
      preroll,
      eventType,
      _passthroughFields
    )

  override def canEqual(other: Any): Boolean = other.isInstanceOf[MediaPlayback]

  private[this] def _equals(other: MediaPlayback): Boolean =
      this.productArity == other.productArity &&
      this.productIterator.sameElements(other.productIterator) &&
      this._passthroughFields == other._passthroughFields

  override def equals(other: Any): Boolean =
    canEqual(other) && _equals(other.asInstanceOf[MediaPlayback])

  override def hashCode: Int = {
    _root_.scala.runtime.ScalaRunTime._hashCode(this)
  }

  override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)

  override def productPrefix: String = "MediaPlayback"

  def _codec: ValidatingThriftStructCodec3[MediaPlayback] = MediaPlayback

  def newBuilder(): StructBuilder[MediaPlayback] = new MediaPlaybackStructBuilder(_root_.scala.Some(this), fieldTypes)
}

private[event] class MediaPlaybackStructBuilder(instance: _root_.scala.Option[MediaPlayback], fieldTypes: IndexedSeq[ClassTag[_]])
    extends StructBuilder[MediaPlayback](fieldTypes) {

  def build(): MediaPlayback = {
    val _fieldArray = fieldArray // shadow variable
    if (instance.isDefined) {
      val instanceValue = instance.get
      MediaPlayback(
        if (_fieldArray(0) == null) instanceValue.mediaId else _fieldArray(0).asInstanceOf[String],
        if (_fieldArray(1) == null) instanceValue.mediaType else _fieldArray(1).asInstanceOf[ophan.thrift.event.MediaType],
        if (_fieldArray(2) == null) instanceValue.preroll else _fieldArray(2).asInstanceOf[Boolean],
        if (_fieldArray(3) == null) instanceValue.eventType else _fieldArray(3).asInstanceOf[ophan.thrift.event.MediaEvent]
      )
    } else {
      if (genericArrayOps(_fieldArray).contains(null)) throw new InvalidFieldsException(structBuildError("MediaPlayback"))
      MediaPlayback(
        _fieldArray(0).asInstanceOf[String],
        _fieldArray(1).asInstanceOf[ophan.thrift.event.MediaType],
        _fieldArray(2).asInstanceOf[Boolean],
        _fieldArray(3).asInstanceOf[ophan.thrift.event.MediaEvent]
      )
    }
  }
}

