/**
 * Generated by Scrooge
 *   version: 21.6.0
 *   rev: 94297159b516fc8e4ffb3d2552aeee4e1c904731
 *   built at: 20210622-155759
 */
package ophan.thrift.event

import com.twitter.io.Buf
import com.twitter.scrooge.{
  InvalidFieldsException,
  LazyTProtocol,
  StructBuilder,
  StructBuilderFactory,
  TFieldBlob,
  ThriftStruct,
  ThriftStructCodec3,
  ThriftStructField,
  ThriftStructFieldInfo,
  ThriftStructMetaData,
  ValidatingThriftStruct,
  ValidatingThriftStructCodec3
}
import org.apache.thrift.protocol._
import org.apache.thrift.transport.TMemoryBuffer
import scala.collection.immutable.{Map => immutable$Map}
import scala.collection.mutable.Builder
import scala.reflect.{ClassTag, classTag}

/**
* Represents a url either of a page served or a referrer
**/
object Url extends ValidatingThriftStructCodec3[Url] with StructBuilderFactory[Url] {
  private[this] val _protos: _root_.com.twitter.scrooge.internal.TProtocols = _root_.com.twitter.scrooge.internal.TProtocols()

  val Struct: TStruct = new TStruct("Url")
  val RawField: TField = new TField("raw", TType.STRING, 1)
  val RawFieldManifest: Manifest[String] = manifest[String]
  val HostField: TField = new TField("host", TType.STRING, 2)
  val HostFieldManifest: Manifest[String] = manifest[String]
  val DomainField: TField = new TField("domain", TType.STRING, 6)
  val DomainFieldManifest: Manifest[String] = manifest[String]
  val PathField: TField = new TField("path", TType.STRING, 3)
  val PathFieldManifest: Manifest[String] = manifest[String]
  val SiteField: TField = new TField("site", TType.ENUM, 5)
  val SiteFieldI32: TField = new TField("site", TType.I32, 5)
  val SiteFieldManifest: Manifest[ophan.thrift.event.SignificantSite] = manifest[ophan.thrift.event.SignificantSite]
  val SynthesisedField: TField = new TField("synthesised", TType.BOOL, 11)
  val SynthesisedFieldManifest: Manifest[Boolean] = manifest[Boolean]

  /**
   * Field information in declaration order.
   */
  lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
    new ThriftStructFieldInfo(
      RawField,
      false,
      true,
      RawFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      HostField,
      false,
      true,
      HostFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      DomainField,
      false,
      true,
      DomainFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      PathField,
      false,
      true,
      PathFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      SiteField,
      true,
      false,
      SiteFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.event.SignificantSite.unsafeEmpty)
    ),
    new ThriftStructFieldInfo(
      SynthesisedField,
      false,
      false,
      SynthesisedFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      Some[Boolean](false),
      _root_.scala.Option(false)
    )
  )


  val structAnnotations: immutable$Map[String, String] =
    immutable$Map.empty[String, String]

  private val fieldTypes: IndexedSeq[ClassTag[_]] = IndexedSeq[ClassTag[_]](
    classTag[String].asInstanceOf[ClassTag[_]],
    classTag[String].asInstanceOf[ClassTag[_]],
    classTag[String].asInstanceOf[ClassTag[_]],
    classTag[String].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.Option[ophan.thrift.event.SignificantSite]].asInstanceOf[ClassTag[_]],
    classTag[Boolean].asInstanceOf[ClassTag[_]]
  )

  private[this] val structFields: Seq[ThriftStructField[Url]] = Seq[ThriftStructField[Url]](
    new ThriftStructField[Url](
      RawField,
      _root_.scala.Some(RawFieldManifest),
      classOf[Url]) {
        def getValue[R](struct: Url): R = struct.raw.asInstanceOf[R]
    },
    new ThriftStructField[Url](
      HostField,
      _root_.scala.Some(HostFieldManifest),
      classOf[Url]) {
        def getValue[R](struct: Url): R = struct.host.asInstanceOf[R]
    },
    new ThriftStructField[Url](
      DomainField,
      _root_.scala.Some(DomainFieldManifest),
      classOf[Url]) {
        def getValue[R](struct: Url): R = struct.domain.asInstanceOf[R]
    },
    new ThriftStructField[Url](
      PathField,
      _root_.scala.Some(PathFieldManifest),
      classOf[Url]) {
        def getValue[R](struct: Url): R = struct.path.asInstanceOf[R]
    },
    new ThriftStructField[Url](
      SiteField,
      _root_.scala.Some(SiteFieldManifest),
      classOf[Url]) {
        def getValue[R](struct: Url): R = struct.site.asInstanceOf[R]
    },
    new ThriftStructField[Url](
      SynthesisedField,
      _root_.scala.Some(SynthesisedFieldManifest),
      classOf[Url]) {
        def getValue[R](struct: Url): R = struct.synthesised.asInstanceOf[R]
    }
  )

  override lazy val metaData: ThriftStructMetaData[Url] =
    ThriftStructMetaData(this, structFields, fieldInfos, Nil, structAnnotations)

  /**
   * Checks that all required fields are non-null.
   */
  def validate(_item: Url): Unit = {
    if (_item.raw eq null) throw new TProtocolException("Required field raw cannot be null")
    if (_item.host eq null) throw new TProtocolException("Required field host cannot be null")
    if (_item.domain eq null) throw new TProtocolException("Required field domain cannot be null")
    if (_item.path eq null) throw new TProtocolException("Required field path cannot be null")
  }

  /**
   * Checks that the struct is a valid as a new instance. If there are any missing required or
   * construction required fields, return a non-empty list.
   */
  def validateNewInstance(item: Url): scala.Seq[com.twitter.scrooge.validation.Issue] = {
    val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]

    if (item.raw eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(0))
    buf ++= validateField(item.raw)
    if (item.host eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(1))
    buf ++= validateField(item.host)
    if (item.domain eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(2))
    buf ++= validateField(item.domain)
    if (item.path eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(3))
    buf ++= validateField(item.path)
    buf ++= validateField(item.site)
    buf ++= validateField(item.synthesised)
    buf.toList
  }

  def withoutPassthroughFields(original: Url): Url =
    new Immutable(
      raw = original.raw,
      host = original.host,
      domain = original.domain,
      path = original.path,
      site = original.site,
      synthesised = original.synthesised
    )

  lazy val unsafeEmpty: Url = {
    val raw: String = "empty"
    val host: String = "empty"
    val domain: String = "empty"
    val path: String = "empty"
    val site: _root_.scala.Option[ophan.thrift.event.SignificantSite] = _root_.scala.None
    val synthesised: Boolean = false

    new Immutable(
      raw,
      host,
      domain,
      path,
      site,
      synthesised,
      _root_.com.twitter.scrooge.internal.TProtocols.NoPassthroughFields
    )
  }

  def newBuilder(): StructBuilder[Url] = new UrlStructBuilder(_root_.scala.None, fieldTypes)

  override def encode(_item: Url, _oproto: TProtocol): Unit = {
    _item.write(_oproto)
  }


  override def decode(_iprot: TProtocol): Url = {
    if (_iprot.isInstanceOf[LazyTProtocol]) {
      decodeInternal(_iprot, true)
    } else {
      decodeInternal(_iprot, false)
    }
  }

  private[event] def eagerDecode(_iprot: TProtocol): Url = {
    decodeInternal(_iprot, false)
  }

  private[this] def decodeInternal(_iprot: TProtocol, lazily: Boolean): Url = {
    var rawOffset: Int = -1
    var raw: String = null
    var _got_raw = false
    var hostOffset: Int = -1
    var host: String = null
    var _got_host = false
    var domainOffset: Int = -1
    var domain: String = null
    var _got_domain = false
    var pathOffset: Int = -1
    var path: String = null
    var _got_path = false
    var site: Option[ophan.thrift.event.SignificantSite] = None
    var synthesised: Boolean = false

    var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
    var _done = false
    val _start_offset = if (lazily) _iprot.asInstanceOf[LazyTProtocol].offset else -1

    _iprot.readStructBegin()
    do {
      val _field = _iprot.readFieldBegin()
      val _fieldType = _field.`type`
      if (_fieldType == TType.STOP) {
        _done = true
      } else {
        _field.id match {
          case 1 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "raw")
            if (lazily)
              rawOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              raw = _iprot.readString()
            _got_raw = true
          case 2 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "host")
            if (lazily)
              hostOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              host = _iprot.readString()
            _got_host = true
          case 6 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "domain")
            if (lazily)
              domainOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              domain = _iprot.readString()
            _got_domain = true
          case 3 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "path")
            if (lazily)
              pathOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              path = _iprot.readString()
            _got_path = true
          case 5 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateEnumFieldType(_fieldType, "site")
            site = _root_.scala.Some(ophan.thrift.event.SignificantSite.getOrUnknown(_iprot.readI32()))
          case 11 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.BOOL, _fieldType, "synthesised")
            synthesised = _iprot.readBool()
          case _ =>
            _passthroughFields = _root_.com.twitter.scrooge.internal.TProtocols.readPassthroughField(_iprot, _field, _passthroughFields)
        }
        _iprot.readFieldEnd()
      }
    } while (!_done)
    _iprot.readStructEnd()

    if (!_got_raw) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("Url", "raw")
    if (!_got_host) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("Url", "host")
    if (!_got_domain) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("Url", "domain")
    if (!_got_path) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("Url", "path")

    val _passthroughFieldsResult =
      if (_passthroughFields eq null) _root_.com.twitter.scrooge.internal.TProtocols.NoPassthroughFields
      else _passthroughFields.result()
    if (lazily) {
      val _lazyProt = _iprot.asInstanceOf[LazyTProtocol]
      new LazyImmutable(
        _lazyProt,
        _lazyProt.buffer,
        _start_offset,
        _lazyProt.offset,
        rawOffset,
        hostOffset,
        domainOffset,
        pathOffset,
        site,
        synthesised,
        _passthroughFieldsResult
      )
    } else {
      new Immutable(
        raw,
        host,
        domain,
        path,
        site,
        synthesised,
        _passthroughFieldsResult
      )
    }
  }

  def apply(
    raw: String,
    host: String,
    domain: String,
    path: String,
    site: _root_.scala.Option[ophan.thrift.event.SignificantSite] = _root_.scala.None,
    synthesised: Boolean = false
  ): Url =
    new Immutable(
      raw,
      host,
      domain,
      path,
      site,
      synthesised
    )

  def unapply(_item: Url): _root_.scala.Option[_root_.scala.Tuple6[String, String, String, String, Option[ophan.thrift.event.SignificantSite], Boolean]] = _root_.scala.Some(_item.toTuple)



  object Immutable extends ThriftStructCodec3[Url] {
    override def encode(_item: Url, _oproto: TProtocol): Unit = { _item.write(_oproto) }
    override def decode(_iprot: TProtocol): Url = Url.decode(_iprot)
    override lazy val metaData: ThriftStructMetaData[Url] = Url.metaData
  }

  /**
   * The default read-only implementation of Url.  You typically should not need to
   * directly reference this class; instead, use the Url.apply method to construct
   * new instances.
   */
  class Immutable(
      val raw: String,
      val host: String,
      val domain: String,
      val path: String,
      val site: _root_.scala.Option[ophan.thrift.event.SignificantSite],
      val synthesised: Boolean,
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends Url {
    def this(
      raw: String,
      host: String,
      domain: String,
      path: String,
      site: _root_.scala.Option[ophan.thrift.event.SignificantSite] = _root_.scala.None,
      synthesised: Boolean = false
    ) = this(
      raw,
      host,
      domain,
      path,
      site,
      synthesised,
      immutable$Map.empty[Short, TFieldBlob]
    )
  }

  /**
   * This is another Immutable, this however keeps strings as lazy values that are lazily decoded from the backing
   * array byte on read.
   */
  private[this] class LazyImmutable(
      _proto: LazyTProtocol,
      _buf: Array[Byte],
      _start_offset: Int,
      _end_offset: Int,
      rawOffset: Int,
      hostOffset: Int,
      domainOffset: Int,
      pathOffset: Int,
      val site: _root_.scala.Option[ophan.thrift.event.SignificantSite],
      val synthesised: Boolean,
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends Url {

    override def write(_oprot: TProtocol): Unit = {
      if (_oprot.isInstanceOf[LazyTProtocol]) {
        _oprot.asInstanceOf[LazyTProtocol].writeRaw(_buf, _start_offset, _end_offset - _start_offset)
      } else {
        super.write(_oprot)
      }
    }

    lazy val raw: String =
      if (rawOffset == -1)
        null
      else {
        _proto.decodeString(_buf, rawOffset)
      }
    lazy val host: String =
      if (hostOffset == -1)
        null
      else {
        _proto.decodeString(_buf, hostOffset)
      }
    lazy val domain: String =
      if (domainOffset == -1)
        null
      else {
        _proto.decodeString(_buf, domainOffset)
      }
    lazy val path: String =
      if (pathOffset == -1)
        null
      else {
        _proto.decodeString(_buf, pathOffset)
      }

    /**
     * Override the super hash code to make it a lazy val rather than def.
     *
     * Calculating the hash code can be expensive, caching it where possible
     * can provide significant performance wins. (Key in a hash map for instance)
     * Usually not safe since the normal constructor will accept a mutable map or
     * set as an arg
     * Here however we control how the class is generated from serialized data.
     * With the class private and the contract that we throw away our mutable references
     * having the hash code lazy here is safe.
     */
    override lazy val hashCode: Int = super.hashCode
  }

}

/**
 * Prefer the companion object's [[ophan.thrift.event.Url.apply]]
 * for construction if you don't need to specify passthrough fields.
 */
trait Url
  extends ThriftStruct
  with _root_.scala.Product6[String, String, String, String, Option[ophan.thrift.event.SignificantSite], Boolean]
  with ValidatingThriftStruct[Url]
  with java.io.Serializable
{
  import Url._

  /** The full raw URL as provided to ophan, potentially including
     * query string and fragment identifier
     *
     *  Be careful about using the value of this field: almost certainly
     *  you want to use the combination of domain and path instead, which are cleared of
     *  non-significant variation.
     */
  def raw: String
  /** the host of this url with no parsing or normalisation performed.
   *
   *  Be careful about using the value of this field: almost certainly
   *  you want to use the combination of domain and path instead, which are cleared of
   *  non-significant variation.
   **/
  def host: String
  /**
   * the domain of this url.
   *
   * This is the host stripped down to one level below the top level domain.
   *
   * e.g.
   * www.theguardian.com => theguardian.com
   * news.google.co.uk => google.co.uk
   * membership.theguardian.com => theguardian.com
   **/
  def domain: String
  /**
  * The path served on the given host, without query strings or fragment identifiers.
  *
  * For guardian urls, processing is performed on the path -
  * especially for the native mobile apps - to try to make the url
  * match up with those on www.theguardian.com
  *
  * Path will always start with a /.
  **/
  def path: String
  /**
  * Indicates sites that we really care about, factoring out the variation
  * on domain that they sometimes contain.
  *
  * Note that were this url represents a page on a site that we don't consider significant,
  * this value will be unpopulated. You should probably use domain to aggregate in that case.
  **/
  def site: _root_.scala.Option[ophan.thrift.event.SignificantSite]
  /** Indicates whether this url was synthesised in some way by ophan */
  def synthesised: Boolean

  def _passthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty

  def _1: String = raw
  def _2: String = host
  def _3: String = domain
  def _4: String = path
  def _5: _root_.scala.Option[ophan.thrift.event.SignificantSite] = site
  def _6: Boolean = synthesised

  def toTuple: _root_.scala.Tuple6[String, String, String, String, Option[ophan.thrift.event.SignificantSite], Boolean] =
    _root_.scala.Tuple6[String, String, String, String, Option[ophan.thrift.event.SignificantSite], Boolean](
      raw,
      host,
      domain,
      path,
      site,
      synthesised
    )


  /**
   * Gets a field value encoded as a binary blob using TCompactProtocol.  If the specified field
   * is present in the passthrough map, that value is returned.  Otherwise, if the specified field
   * is known and not optional and set to None, then the field is serialized and returned.
   */
  def getFieldBlob(_fieldId: Short): _root_.scala.Option[TFieldBlob] = {
    val passedthroughValue = _passthroughFields.get(_fieldId)
    if (passedthroughValue.isDefined) {
      passedthroughValue
    } else {
      val _protos = _root_.com.twitter.scrooge.internal.TProtocols()
      val _buff = new TMemoryBuffer(32)
      val _oprot = new TCompactProtocol(_buff)

      val _fieldOpt: _root_.scala.Option[TField] = _fieldId match {
        case 1 =>
          if (raw ne null) {
            _oprot.writeString(raw)
            _root_.scala.Some(Url.RawField)
          } else {
            _root_.scala.None
          }
        case 2 =>
          if (host ne null) {
            _oprot.writeString(host)
            _root_.scala.Some(Url.HostField)
          } else {
            _root_.scala.None
          }
        case 6 =>
          if (domain ne null) {
            _oprot.writeString(domain)
            _root_.scala.Some(Url.DomainField)
          } else {
            _root_.scala.None
          }
        case 3 =>
          if (path ne null) {
            _oprot.writeString(path)
            _root_.scala.Some(Url.PathField)
          } else {
            _root_.scala.None
          }
        case 5 =>
          if (site.isDefined) {
            _oprot.writeI32(site.get.value)
            _root_.scala.Some(Url.SiteField)
          } else {
            _root_.scala.None
          }
        case 11 =>
            _oprot.writeBool(synthesised)
            _root_.scala.Some(Url.SynthesisedField)
        case _ => _root_.scala.None
      }
      if (_fieldOpt.isDefined) {
        _root_.scala.Some(TFieldBlob(_fieldOpt.get, Buf.ByteArray.Owned(_buff.getArray)))
      } else {
        _root_.scala.None
      }
    }
  }


  /**
   * Collects TCompactProtocol-encoded field values according to `getFieldBlob` into a map.
   */
  def getFieldBlobs(ids: TraversableOnce[Short]): immutable$Map[Short, TFieldBlob] =
    (ids.flatMap { id => getFieldBlob(id).map { fieldBlob => (id, fieldBlob) } }).toMap

  /**
   * Sets a field using a TCompactProtocol-encoded binary blob.  If the field is a known
   * field, the blob is decoded and the field is set to the decoded value.  If the field
   * is unknown and passthrough fields are enabled, then the blob will be stored in
   * _passthroughFields.
   */
  def setField(_blob: TFieldBlob): Url = {
    val _protos: _root_.com.twitter.scrooge.internal.TProtocols = _root_.com.twitter.scrooge.internal.TProtocols()
    var raw: String = this.raw
    var host: String = this.host
    var domain: String = this.domain
    var path: String = this.path
    var site: _root_.scala.Option[ophan.thrift.event.SignificantSite] = this.site
    var synthesised: Boolean = this.synthesised
    var _passthroughFields = this._passthroughFields
    val _iprot = _blob.read 
    _blob.id match {
      case 1 =>
        raw = _iprot.readString()
      case 2 =>
        host = _iprot.readString()
      case 6 =>
        domain = _iprot.readString()
      case 3 =>
        path = _iprot.readString()
      case 5 =>
        site = _root_.scala.Some(ophan.thrift.event.SignificantSite.getOrUnknown(_iprot.readI32()))
      case 11 =>
        synthesised = _iprot.readBool()
      case _ => _passthroughFields += _root_.scala.Tuple2(_blob.id, _blob)
    }
    new Immutable(
      raw,
      host,
      domain,
      path,
      site,
      synthesised,
      _passthroughFields
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetField(_fieldId: Short): Url = {
    var raw: String = this.raw
    var host: String = this.host
    var domain: String = this.domain
    var path: String = this.path
    var site: _root_.scala.Option[ophan.thrift.event.SignificantSite] = this.site
    var synthesised: Boolean = this.synthesised

    _fieldId match {
      case 1 =>
        raw = null
      case 2 =>
        host = null
      case 6 =>
        domain = null
      case 3 =>
        path = null
      case 5 =>
        site = _root_.scala.None
      case 11 =>
        synthesised = false
      case _ =>
    }
    new Immutable(
      raw,
      host,
      domain,
      path,
      site,
      synthesised,
      _passthroughFields - _fieldId
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetRaw: Url = unsetField(1)

  def unsetHost: Url = unsetField(2)

  def unsetDomain: Url = unsetField(6)

  def unsetPath: Url = unsetField(3)

  def unsetSite: Url = unsetField(5)

  def unsetSynthesised: Url = unsetField(11)


  override def write(_oprot: TProtocol): Unit = {
    Url.validate(this)
    val _protos = _root_.com.twitter.scrooge.internal.TProtocols()
    _oprot.writeStructBegin(Struct)
    if (raw ne null) {
      _oprot.writeFieldBegin(RawField)
      _oprot.writeString(raw)
      _oprot.writeFieldEnd()
    }
    if (host ne null) {
      _oprot.writeFieldBegin(HostField)
      _oprot.writeString(host)
      _oprot.writeFieldEnd()
    }
    if (domain ne null) {
      _oprot.writeFieldBegin(DomainField)
      _oprot.writeString(domain)
      _oprot.writeFieldEnd()
    }
    if (path ne null) {
      _oprot.writeFieldBegin(PathField)
      _oprot.writeString(path)
      _oprot.writeFieldEnd()
    }
    if (site.isDefined) {
      _oprot.writeFieldBegin(SiteFieldI32)
      _oprot.writeI32(site.get.value)
      _oprot.writeFieldEnd()
    }
    _oprot.writeFieldBegin(SynthesisedField)
    _oprot.writeBool(synthesised)
    _oprot.writeFieldEnd()
    _root_.com.twitter.scrooge.internal.TProtocols.finishWritingStruct(_oprot, _passthroughFields)
  }

  def copy(
    raw: String = this.raw,
    host: String = this.host,
    domain: String = this.domain,
    path: String = this.path,
    site: _root_.scala.Option[ophan.thrift.event.SignificantSite] = this.site,
    synthesised: Boolean = this.synthesised,
    _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
  ): Url =
    new Immutable(
      raw,
      host,
      domain,
      path,
      site,
      synthesised,
      _passthroughFields
    )

  override def canEqual(other: Any): Boolean = other.isInstanceOf[Url]

  private[this] def _equals(other: Url): Boolean =
      this.productArity == other.productArity &&
      this.productIterator.sameElements(other.productIterator) &&
      this._passthroughFields == other._passthroughFields

  override def equals(other: Any): Boolean =
    canEqual(other) && _equals(other.asInstanceOf[Url])

  override def hashCode: Int = {
    _root_.scala.runtime.ScalaRunTime._hashCode(this)
  }

  override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)

  override def productPrefix: String = "Url"

  def _codec: ValidatingThriftStructCodec3[Url] = Url

  def newBuilder(): StructBuilder[Url] = new UrlStructBuilder(_root_.scala.Some(this), fieldTypes)
}

private[event] class UrlStructBuilder(instance: _root_.scala.Option[Url], fieldTypes: IndexedSeq[ClassTag[_]])
    extends StructBuilder[Url](fieldTypes) {

  def build(): Url = {
    val _fieldArray = fieldArray // shadow variable
    if (instance.isDefined) {
      val instanceValue = instance.get
      Url(
        if (_fieldArray(0) == null) instanceValue.raw else _fieldArray(0).asInstanceOf[String],
        if (_fieldArray(1) == null) instanceValue.host else _fieldArray(1).asInstanceOf[String],
        if (_fieldArray(2) == null) instanceValue.domain else _fieldArray(2).asInstanceOf[String],
        if (_fieldArray(3) == null) instanceValue.path else _fieldArray(3).asInstanceOf[String],
        if (_fieldArray(4) == null) instanceValue.site else _fieldArray(4).asInstanceOf[_root_.scala.Option[ophan.thrift.event.SignificantSite]],
        if (_fieldArray(5) == null) instanceValue.synthesised else _fieldArray(5).asInstanceOf[Boolean]
      )
    } else {
      if (genericArrayOps(_fieldArray).contains(null)) throw new InvalidFieldsException(structBuildError("Url"))
      Url(
        _fieldArray(0).asInstanceOf[String],
        _fieldArray(1).asInstanceOf[String],
        _fieldArray(2).asInstanceOf[String],
        _fieldArray(3).asInstanceOf[String],
        _fieldArray(4).asInstanceOf[_root_.scala.Option[ophan.thrift.event.SignificantSite]],
        _fieldArray(5).asInstanceOf[Boolean]
      )
    }
  }
}

