/**
 * Generated by Scrooge
 *   version: 21.6.0
 *   rev: 94297159b516fc8e4ffb3d2552aeee4e1c904731
 *   built at: 20210622-155759
 */
package ophan.thrift.nativeapp

import com.twitter.io.Buf
import com.twitter.scrooge.{
  InvalidFieldsException,
  LazyTProtocol,
  StructBuilder,
  StructBuilderFactory,
  TFieldBlob,
  ThriftStruct,
  ThriftStructCodec3,
  ThriftStructField,
  ThriftStructFieldInfo,
  ThriftStructMetaData,
  ValidatingThriftStruct,
  ValidatingThriftStructCodec3
}
import org.apache.thrift.protocol._
import org.apache.thrift.transport.TMemoryBuffer
import scala.collection.immutable.{Map => immutable$Map}
import scala.collection.mutable.Builder
import scala.reflect.{ClassTag, classTag}

/**
* This is the root object that represents a tracking submission from native apps.
*
* This can be supplied to Ophan in one of two ways:
*
* <ol>
*   <li>Create the equivalent json and POST the json to https://ophan.theguardian.com/mob with a content type
*   of application/json</li>
*   <li>Create a thift binary blob in compact binary protocol format from
*   <a href="https://github.com/guardian/ophan/blob/main/event-model/src/main/thrift/nativeapp.thrift">this definition</a>
*   and POST to
*   https://ophan.theguardian.com/mob a content type of application/vnd.apache.thrift.compact</li>
* </ol>
*
* Note that, for largely backwards compatibility reasons, in some cases we allow synonyms for enum values in
* json; these are noted in the descriptions below.
**/
object NativeAppSubmission extends ValidatingThriftStructCodec3[NativeAppSubmission] with StructBuilderFactory[NativeAppSubmission] {
  private[this] val _protos: _root_.com.twitter.scrooge.internal.TProtocols = _root_.com.twitter.scrooge.internal.TProtocols()

  val Struct: TStruct = new TStruct("NativeAppSubmission")
  val AppField: TField = new TField("app", TType.STRUCT, 2)
  val AppFieldManifest: Manifest[ophan.thrift.nativeapp.App] = manifest[ophan.thrift.nativeapp.App]
  val DeviceField: TField = new TField("device", TType.STRUCT, 3)
  val DeviceFieldManifest: Manifest[ophan.thrift.nativeapp.Device] = manifest[ophan.thrift.nativeapp.Device]
  val DeviceIdField: TField = new TField("deviceId", TType.STRING, 4)
  val DeviceIdFieldManifest: Manifest[String] = manifest[String]
  val UserIdField: TField = new TField("userId", TType.STRING, 5)
  val UserIdFieldManifest: Manifest[String] = manifest[String]
  val ObsoleteKruxIdField: TField = new TField("OBSOLETE_kruxId", TType.STRING, 8)
  val ObsoleteKruxIdFieldManifest: Manifest[String] = manifest[String]
  val SubscriptionIdField: TField = new TField("subscriptionId", TType.ENUM, 6)
  val SubscriptionIdFieldI32: TField = new TField("subscriptionId", TType.I32, 6)
  val SubscriptionIdFieldManifest: Manifest[ophan.thrift.subscription.SubscriptionType] = manifest[ophan.thrift.subscription.SubscriptionType]
  val EventsField: TField = new TField("events", TType.LIST, 7)
  val EventsFieldManifest: Manifest[_root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]] = manifest[_root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]]
  val MembershipTierField: TField = new TField("membershipTier", TType.ENUM, 9)
  val MembershipTierFieldI32: TField = new TField("membershipTier", TType.I32, 9)
  val MembershipTierFieldManifest: Manifest[ophan.thrift.subscription.MembershipTier] = manifest[ophan.thrift.subscription.MembershipTier]

  /**
   * Field information in declaration order.
   */
  lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
    new ThriftStructFieldInfo(
      AppField,
      false,
      true,
      AppFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.nativeapp.App.unsafeEmpty)
    ),
    new ThriftStructFieldInfo(
      DeviceField,
      true,
      false,
      DeviceFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.nativeapp.Device.unsafeEmpty)
    ),
    new ThriftStructFieldInfo(
      DeviceIdField,
      false,
      true,
      DeviceIdFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      UserIdField,
      true,
      false,
      UserIdFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      ObsoleteKruxIdField,
      true,
      false,
      ObsoleteKruxIdFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option("empty")
    ),
    new ThriftStructFieldInfo(
      SubscriptionIdField,
      true,
      false,
      SubscriptionIdFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.subscription.SubscriptionType.unsafeEmpty)
    ),
    new ThriftStructFieldInfo(
      EventsField,
      false,
      true,
      EventsFieldManifest,
      _root_.scala.None,
      _root_.scala.Some(manifest[ophan.thrift.nativeapp.Event]),
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(_root_.scala.collection.immutable.Nil)
    ),
    new ThriftStructFieldInfo(
      MembershipTierField,
      true,
      false,
      MembershipTierFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None,
      _root_.scala.Option(ophan.thrift.subscription.MembershipTier.unsafeEmpty)
    )
  )


  val structAnnotations: immutable$Map[String, String] =
    immutable$Map.empty[String, String]

  private val fieldTypes: IndexedSeq[ClassTag[_]] = IndexedSeq[ClassTag[_]](
    classTag[ophan.thrift.nativeapp.App].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.Option[ophan.thrift.nativeapp.Device]].asInstanceOf[ClassTag[_]],
    classTag[String].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.Option[String]].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.Option[String]].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.Option[ophan.thrift.subscription.SubscriptionType]].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]].asInstanceOf[ClassTag[_]],
    classTag[_root_.scala.Option[ophan.thrift.subscription.MembershipTier]].asInstanceOf[ClassTag[_]]
  )

  private[this] val structFields: Seq[ThriftStructField[NativeAppSubmission]] = Seq[ThriftStructField[NativeAppSubmission]](
    new ThriftStructField[NativeAppSubmission](
      AppField,
      _root_.scala.Some(AppFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.app.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      DeviceField,
      _root_.scala.Some(DeviceFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.device.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      DeviceIdField,
      _root_.scala.Some(DeviceIdFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.deviceId.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      UserIdField,
      _root_.scala.Some(UserIdFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.userId.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      ObsoleteKruxIdField,
      _root_.scala.Some(ObsoleteKruxIdFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.obsoleteKruxId.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      SubscriptionIdField,
      _root_.scala.Some(SubscriptionIdFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.subscriptionId.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      EventsField,
      _root_.scala.Some(EventsFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.events.asInstanceOf[R]
    },
    new ThriftStructField[NativeAppSubmission](
      MembershipTierField,
      _root_.scala.Some(MembershipTierFieldManifest),
      classOf[NativeAppSubmission]) {
        def getValue[R](struct: NativeAppSubmission): R = struct.membershipTier.asInstanceOf[R]
    }
  )

  override lazy val metaData: ThriftStructMetaData[NativeAppSubmission] =
    ThriftStructMetaData(this, structFields, fieldInfos, Nil, structAnnotations)

  /**
   * Checks that all required fields are non-null.
   */
  def validate(_item: NativeAppSubmission): Unit = {
    if (_item.app eq null) throw new TProtocolException("Required field app cannot be null")
    if (_item.deviceId eq null) throw new TProtocolException("Required field deviceId cannot be null")
    if (_item.events eq null) throw new TProtocolException("Required field events cannot be null")
  }

  /**
   * Checks that the struct is a valid as a new instance. If there are any missing required or
   * construction required fields, return a non-empty list.
   */
  def validateNewInstance(item: NativeAppSubmission): scala.Seq[com.twitter.scrooge.validation.Issue] = {
    val buf = scala.collection.mutable.ListBuffer.empty[com.twitter.scrooge.validation.Issue]

    if (item.app eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(0))
    buf ++= validateField(item.app)
    buf ++= validateField(item.device)
    if (item.deviceId eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(2))
    buf ++= validateField(item.deviceId)
    buf ++= validateField(item.userId)
    buf ++= validateField(item.obsoleteKruxId)
    buf ++= validateField(item.subscriptionId)
    if (item.events eq null)
      buf += com.twitter.scrooge.validation.MissingRequiredField(fieldInfos.apply(6))
    buf ++= validateField(item.events)
    buf ++= validateField(item.membershipTier)
    buf.toList
  }

  def withoutPassthroughFields(original: NativeAppSubmission): NativeAppSubmission =
    new Immutable(
      app =
        {
          val field = original.app
          ophan.thrift.nativeapp.App.withoutPassthroughFields(field)
        },
      device =
        {
          val field = original.device
          field.map { field =>
            ophan.thrift.nativeapp.Device.withoutPassthroughFields(field)
          }
        },
      deviceId = original.deviceId,
      userId = original.userId,
      obsoleteKruxId = original.obsoleteKruxId,
      subscriptionId = original.subscriptionId,
      events =
        {
          val field = original.events
          field.map { field =>
            ophan.thrift.nativeapp.Event.withoutPassthroughFields(field)
          }
        },
      membershipTier = original.membershipTier
    )

  lazy val unsafeEmpty: NativeAppSubmission = {
    val app: ophan.thrift.nativeapp.App = ophan.thrift.nativeapp.App.unsafeEmpty
    val device: _root_.scala.Option[ophan.thrift.nativeapp.Device] = _root_.scala.None
    val deviceId: String = "empty"
    val userId: _root_.scala.Option[String] = _root_.scala.None
    val obsoleteKruxId: _root_.scala.Option[String] = _root_.scala.None
    val subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = _root_.scala.None
    val events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = _root_.scala.collection.immutable.Nil
    val membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = _root_.scala.None

    new Immutable(
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier,
      _root_.com.twitter.scrooge.internal.TProtocols.NoPassthroughFields
    )
  }

  def newBuilder(): StructBuilder[NativeAppSubmission] = new NativeAppSubmissionStructBuilder(_root_.scala.None, fieldTypes)

  override def encode(_item: NativeAppSubmission, _oproto: TProtocol): Unit = {
    _item.write(_oproto)
  }


  override def decode(_iprot: TProtocol): NativeAppSubmission = {
    if (_iprot.isInstanceOf[LazyTProtocol]) {
      decodeInternal(_iprot, true)
    } else {
      decodeInternal(_iprot, false)
    }
  }

  private[nativeapp] def eagerDecode(_iprot: TProtocol): NativeAppSubmission = {
    decodeInternal(_iprot, false)
  }

  private[this] def decodeInternal(_iprot: TProtocol, lazily: Boolean): NativeAppSubmission = {
    var app: ophan.thrift.nativeapp.App = null
    var _got_app = false
    var device: Option[ophan.thrift.nativeapp.Device] = None
    var deviceIdOffset: Int = -1
    var deviceId: String = null
    var _got_deviceId = false
    var userIdOffset: Int = -1
    var userId: Option[String] = None
    var OBSOLETE_kruxIdOffset: Int = -1
    var obsoleteKruxId: Option[String] = None
    var subscriptionId: Option[ophan.thrift.subscription.SubscriptionType] = None
    var events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = _root_.scala.collection.immutable.Nil
    var _got_events = false
    var membershipTier: Option[ophan.thrift.subscription.MembershipTier] = None

    var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
    var _done = false
    val _start_offset = if (lazily) _iprot.asInstanceOf[LazyTProtocol].offset else -1

    _iprot.readStructBegin()
    do {
      val _field = _iprot.readFieldBegin()
      val _fieldType = _field.`type`
      if (_fieldType == TType.STOP) {
        _done = true
      } else {
        _field.id match {
          case 2 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRUCT, _fieldType, "app")
            app = ophan.thrift.nativeapp.App.decode(_iprot)
            _got_app = true
          case 3 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRUCT, _fieldType, "device")
            device = _root_.scala.Some(ophan.thrift.nativeapp.Device.decode(_iprot))
          case 4 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "deviceId")
            if (lazily)
              deviceIdOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              deviceId = _iprot.readString()
            _got_deviceId = true
          case 5 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "userId")
            if (lazily)
              userIdOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              userId = _root_.scala.Some(_iprot.readString())
          case 8 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.STRING, _fieldType, "obsoleteKruxId")
            if (lazily)
              OBSOLETE_kruxIdOffset = _iprot.asInstanceOf[LazyTProtocol].offsetSkipString()
            else
              obsoleteKruxId = _root_.scala.Some(_iprot.readString())
          case 6 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateEnumFieldType(_fieldType, "subscriptionId")
            subscriptionId = _root_.scala.Some(ophan.thrift.subscription.SubscriptionType.getOrUnknown(_iprot.readI32()))
          case 7 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateFieldType(TType.LIST, _fieldType, "events")
            events = readEventsValue(_iprot)
            _got_events = true
          case 9 =>
            _root_.com.twitter.scrooge.internal.TProtocols.validateEnumFieldType(_fieldType, "membershipTier")
            membershipTier = _root_.scala.Some(ophan.thrift.subscription.MembershipTier.getOrUnknown(_iprot.readI32()))
          case _ =>
            _passthroughFields = _root_.com.twitter.scrooge.internal.TProtocols.readPassthroughField(_iprot, _field, _passthroughFields)
        }
        _iprot.readFieldEnd()
      }
    } while (!_done)
    _iprot.readStructEnd()

    if (!_got_app) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("NativeAppSubmission", "app")
    if (!_got_deviceId) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("NativeAppSubmission", "deviceId")
    if (!_got_events) _root_.com.twitter.scrooge.internal.TProtocols.throwMissingRequiredField("NativeAppSubmission", "events")

    val _passthroughFieldsResult =
      if (_passthroughFields eq null) _root_.com.twitter.scrooge.internal.TProtocols.NoPassthroughFields
      else _passthroughFields.result()
    if (lazily) {
      val _lazyProt = _iprot.asInstanceOf[LazyTProtocol]
      new LazyImmutable(
        _lazyProt,
        _lazyProt.buffer,
        _start_offset,
        _lazyProt.offset,
        app,
        device,
        deviceIdOffset,
        userIdOffset,
        OBSOLETE_kruxIdOffset,
        subscriptionId,
        events,
        membershipTier,
        _passthroughFieldsResult
      )
    } else {
      new Immutable(
        app,
        device,
        deviceId,
        userId,
        obsoleteKruxId,
        subscriptionId,
        events,
        membershipTier,
        _passthroughFieldsResult
      )
    }
  }

  def apply(
    app: ophan.thrift.nativeapp.App,
    device: _root_.scala.Option[ophan.thrift.nativeapp.Device] = _root_.scala.None,
    deviceId: String,
    userId: _root_.scala.Option[String] = _root_.scala.None,
    obsoleteKruxId: _root_.scala.Option[String] = _root_.scala.None,
    subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = _root_.scala.None,
    events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = _root_.scala.collection.immutable.Nil,
    membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = _root_.scala.None
  ): NativeAppSubmission =
    new Immutable(
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier
    )

  def unapply(_item: NativeAppSubmission): _root_.scala.Option[_root_.scala.Tuple8[ophan.thrift.nativeapp.App, Option[ophan.thrift.nativeapp.Device], String, Option[String], Option[String], Option[ophan.thrift.subscription.SubscriptionType], _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event], Option[ophan.thrift.subscription.MembershipTier]]] = _root_.scala.Some(_item.toTuple)


  private[nativeapp] def readEventsValue(_iprot: TProtocol): _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = {
    _protos.readList(_iprot, ophan.thrift.nativeapp.Event.decode _)
  }

  private def writeEventsValue(_oprot: TProtocol, _value: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]): Unit = {
    _protos.writeList(_oprot, _value, TType.STRUCT, (proto, elem: ophan.thrift.nativeapp.Event) => elem.write(proto))
  }


  object Immutable extends ThriftStructCodec3[NativeAppSubmission] {
    override def encode(_item: NativeAppSubmission, _oproto: TProtocol): Unit = { _item.write(_oproto) }
    override def decode(_iprot: TProtocol): NativeAppSubmission = NativeAppSubmission.decode(_iprot)
    override lazy val metaData: ThriftStructMetaData[NativeAppSubmission] = NativeAppSubmission.metaData
  }

  /**
   * The default read-only implementation of NativeAppSubmission.  You typically should not need to
   * directly reference this class; instead, use the NativeAppSubmission.apply method to construct
   * new instances.
   */
  class Immutable(
      val app: ophan.thrift.nativeapp.App,
      val device: _root_.scala.Option[ophan.thrift.nativeapp.Device],
      val deviceId: String,
      val userId: _root_.scala.Option[String],
      val obsoleteKruxId: _root_.scala.Option[String],
      val subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType],
      val events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event],
      val membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier],
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends NativeAppSubmission {
    def this(
      app: ophan.thrift.nativeapp.App,
      device: _root_.scala.Option[ophan.thrift.nativeapp.Device] = _root_.scala.None,
      deviceId: String,
      userId: _root_.scala.Option[String] = _root_.scala.None,
      obsoleteKruxId: _root_.scala.Option[String] = _root_.scala.None,
      subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = _root_.scala.None,
      events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = _root_.scala.collection.immutable.Nil,
      membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = _root_.scala.None
    ) = this(
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier,
      immutable$Map.empty[Short, TFieldBlob]
    )
  }

  /**
   * This is another Immutable, this however keeps strings as lazy values that are lazily decoded from the backing
   * array byte on read.
   */
  private[this] class LazyImmutable(
      _proto: LazyTProtocol,
      _buf: Array[Byte],
      _start_offset: Int,
      _end_offset: Int,
      val app: ophan.thrift.nativeapp.App,
      val device: _root_.scala.Option[ophan.thrift.nativeapp.Device],
      deviceIdOffset: Int,
      userIdOffset: Int,
      OBSOLETE_kruxIdOffset: Int,
      val subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType],
      val events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event],
      val membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier],
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends NativeAppSubmission {

    override def write(_oprot: TProtocol): Unit = {
      if (_oprot.isInstanceOf[LazyTProtocol]) {
        _oprot.asInstanceOf[LazyTProtocol].writeRaw(_buf, _start_offset, _end_offset - _start_offset)
      } else {
        super.write(_oprot)
      }
    }

    lazy val deviceId: String =
      if (deviceIdOffset == -1)
        null
      else {
        _proto.decodeString(_buf, deviceIdOffset)
      }
    lazy val userId: _root_.scala.Option[String] =
      if (userIdOffset == -1)
        None
      else {
        Some(_proto.decodeString(_buf, userIdOffset))
      }
    lazy val obsoleteKruxId: _root_.scala.Option[String] =
      if (OBSOLETE_kruxIdOffset == -1)
        None
      else {
        Some(_proto.decodeString(_buf, OBSOLETE_kruxIdOffset))
      }

    /**
     * Override the super hash code to make it a lazy val rather than def.
     *
     * Calculating the hash code can be expensive, caching it where possible
     * can provide significant performance wins. (Key in a hash map for instance)
     * Usually not safe since the normal constructor will accept a mutable map or
     * set as an arg
     * Here however we control how the class is generated from serialized data.
     * With the class private and the contract that we throw away our mutable references
     * having the hash code lazy here is safe.
     */
    override lazy val hashCode: Int = super.hashCode
  }

}

/**
 * Prefer the companion object's [[ophan.thrift.nativeapp.NativeAppSubmission.apply]]
 * for construction if you don't need to specify passthrough fields.
 */
trait NativeAppSubmission
  extends ThriftStruct
  with _root_.scala.Product8[ophan.thrift.nativeapp.App, Option[ophan.thrift.nativeapp.Device], String, Option[String], Option[String], Option[ophan.thrift.subscription.SubscriptionType], _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event], Option[ophan.thrift.subscription.MembershipTier]]
  with ValidatingThriftStruct[NativeAppSubmission]
  with java.io.Serializable
{
  import NativeAppSubmission._

  /**
    * App specific information.
    */
  def app: ophan.thrift.nativeapp.App
  /**
    * Device specific information.
    */
  def device: _root_.scala.Option[ophan.thrift.nativeapp.Device]
  /**
    * Equivalent to a web cookie. A way of identifying unique devices.
    */
  def deviceId: String
  /**
    * The user’s guardian user id if they are logged in.
    */
  def userId: _root_.scala.Option[String]
  /**
    * DEPRECATED - Used to be for the user's Krux identifer.
    */
  def obsoleteKruxId: _root_.scala.Option[String]
  /**
    * What type of subscription does this user have?
    */
  def subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType]
  /**
    * The interaction events contained within this submission.
    **/
  def events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]
  /**
    * If this user is a member, what tier are they currently a part of?
    **/
  def membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier]

  def _passthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty

  def _1: ophan.thrift.nativeapp.App = app
  def _2: _root_.scala.Option[ophan.thrift.nativeapp.Device] = device
  def _3: String = deviceId
  def _4: _root_.scala.Option[String] = userId
  def _5: _root_.scala.Option[String] = obsoleteKruxId
  def _6: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = subscriptionId
  def _7: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = events
  def _8: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = membershipTier

  def toTuple: _root_.scala.Tuple8[ophan.thrift.nativeapp.App, Option[ophan.thrift.nativeapp.Device], String, Option[String], Option[String], Option[ophan.thrift.subscription.SubscriptionType], _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event], Option[ophan.thrift.subscription.MembershipTier]] =
    _root_.scala.Tuple8[ophan.thrift.nativeapp.App, Option[ophan.thrift.nativeapp.Device], String, Option[String], Option[String], Option[ophan.thrift.subscription.SubscriptionType], _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event], Option[ophan.thrift.subscription.MembershipTier]](
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier
    )


  /**
   * Gets a field value encoded as a binary blob using TCompactProtocol.  If the specified field
   * is present in the passthrough map, that value is returned.  Otherwise, if the specified field
   * is known and not optional and set to None, then the field is serialized and returned.
   */
  def getFieldBlob(_fieldId: Short): _root_.scala.Option[TFieldBlob] = {
    val passedthroughValue = _passthroughFields.get(_fieldId)
    if (passedthroughValue.isDefined) {
      passedthroughValue
    } else {
      val _protos = _root_.com.twitter.scrooge.internal.TProtocols()
      val _buff = new TMemoryBuffer(32)
      val _oprot = new TCompactProtocol(_buff)

      val _fieldOpt: _root_.scala.Option[TField] = _fieldId match {
        case 2 =>
          if (app ne null) {
            app.write(_oprot)
            _root_.scala.Some(NativeAppSubmission.AppField)
          } else {
            _root_.scala.None
          }
        case 3 =>
          if (device.isDefined) {
            device.get.write(_oprot)
            _root_.scala.Some(NativeAppSubmission.DeviceField)
          } else {
            _root_.scala.None
          }
        case 4 =>
          if (deviceId ne null) {
            _oprot.writeString(deviceId)
            _root_.scala.Some(NativeAppSubmission.DeviceIdField)
          } else {
            _root_.scala.None
          }
        case 5 =>
          if (userId.isDefined) {
            _oprot.writeString(userId.get)
            _root_.scala.Some(NativeAppSubmission.UserIdField)
          } else {
            _root_.scala.None
          }
        case 8 =>
          if (obsoleteKruxId.isDefined) {
            _oprot.writeString(obsoleteKruxId.get)
            _root_.scala.Some(NativeAppSubmission.ObsoleteKruxIdField)
          } else {
            _root_.scala.None
          }
        case 6 =>
          if (subscriptionId.isDefined) {
            _oprot.writeI32(subscriptionId.get.value)
            _root_.scala.Some(NativeAppSubmission.SubscriptionIdField)
          } else {
            _root_.scala.None
          }
        case 7 =>
          if (events ne null) {
            writeEventsValue(_oprot, events)
            _root_.scala.Some(NativeAppSubmission.EventsField)
          } else {
            _root_.scala.None
          }
        case 9 =>
          if (membershipTier.isDefined) {
            _oprot.writeI32(membershipTier.get.value)
            _root_.scala.Some(NativeAppSubmission.MembershipTierField)
          } else {
            _root_.scala.None
          }
        case _ => _root_.scala.None
      }
      if (_fieldOpt.isDefined) {
        _root_.scala.Some(TFieldBlob(_fieldOpt.get, Buf.ByteArray.Owned(_buff.getArray)))
      } else {
        _root_.scala.None
      }
    }
  }


  /**
   * Collects TCompactProtocol-encoded field values according to `getFieldBlob` into a map.
   */
  def getFieldBlobs(ids: TraversableOnce[Short]): immutable$Map[Short, TFieldBlob] =
    (ids.flatMap { id => getFieldBlob(id).map { fieldBlob => (id, fieldBlob) } }).toMap

  /**
   * Sets a field using a TCompactProtocol-encoded binary blob.  If the field is a known
   * field, the blob is decoded and the field is set to the decoded value.  If the field
   * is unknown and passthrough fields are enabled, then the blob will be stored in
   * _passthroughFields.
   */
  def setField(_blob: TFieldBlob): NativeAppSubmission = {
    val _protos: _root_.com.twitter.scrooge.internal.TProtocols = _root_.com.twitter.scrooge.internal.TProtocols()
    var app: ophan.thrift.nativeapp.App = this.app
    var device: _root_.scala.Option[ophan.thrift.nativeapp.Device] = this.device
    var deviceId: String = this.deviceId
    var userId: _root_.scala.Option[String] = this.userId
    var obsoleteKruxId: _root_.scala.Option[String] = this.obsoleteKruxId
    var subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = this.subscriptionId
    var events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = this.events
    var membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = this.membershipTier
    var _passthroughFields = this._passthroughFields
    val _iprot = _blob.read 
    _blob.id match {
      case 2 =>
        app = ophan.thrift.nativeapp.App.decode(_iprot)
      case 3 =>
        device = _root_.scala.Some(ophan.thrift.nativeapp.Device.decode(_iprot))
      case 4 =>
        deviceId = _iprot.readString()
      case 5 =>
        userId = _root_.scala.Some(_iprot.readString())
      case 8 =>
        obsoleteKruxId = _root_.scala.Some(_iprot.readString())
      case 6 =>
        subscriptionId = _root_.scala.Some(ophan.thrift.subscription.SubscriptionType.getOrUnknown(_iprot.readI32()))
      case 7 =>
        events = readEventsValue(_iprot)
      case 9 =>
        membershipTier = _root_.scala.Some(ophan.thrift.subscription.MembershipTier.getOrUnknown(_iprot.readI32()))
      case _ => _passthroughFields += _root_.scala.Tuple2(_blob.id, _blob)
    }
    new Immutable(
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier,
      _passthroughFields
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetField(_fieldId: Short): NativeAppSubmission = {
    var app: ophan.thrift.nativeapp.App = this.app
    var device: _root_.scala.Option[ophan.thrift.nativeapp.Device] = this.device
    var deviceId: String = this.deviceId
    var userId: _root_.scala.Option[String] = this.userId
    var obsoleteKruxId: _root_.scala.Option[String] = this.obsoleteKruxId
    var subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = this.subscriptionId
    var events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = this.events
    var membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = this.membershipTier

    _fieldId match {
      case 2 =>
        app = null
      case 3 =>
        device = _root_.scala.None
      case 4 =>
        deviceId = null
      case 5 =>
        userId = _root_.scala.None
      case 8 =>
        obsoleteKruxId = _root_.scala.None
      case 6 =>
        subscriptionId = _root_.scala.None
      case 7 =>
        events = _root_.scala.collection.immutable.Nil
      case 9 =>
        membershipTier = _root_.scala.None
      case _ =>
    }
    new Immutable(
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier,
      _passthroughFields - _fieldId
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetApp: NativeAppSubmission = unsetField(2)

  def unsetDevice: NativeAppSubmission = unsetField(3)

  def unsetDeviceId: NativeAppSubmission = unsetField(4)

  def unsetUserId: NativeAppSubmission = unsetField(5)

  def unsetObsoleteKruxId: NativeAppSubmission = unsetField(8)

  def unsetSubscriptionId: NativeAppSubmission = unsetField(6)

  def unsetEvents: NativeAppSubmission = unsetField(7)

  def unsetMembershipTier: NativeAppSubmission = unsetField(9)


  override def write(_oprot: TProtocol): Unit = {
    NativeAppSubmission.validate(this)
    val _protos = _root_.com.twitter.scrooge.internal.TProtocols()
    _oprot.writeStructBegin(Struct)
    if (app ne null) {
      _oprot.writeFieldBegin(AppField)
      app.write(_oprot)
      _oprot.writeFieldEnd()
    }
    if (device.isDefined) {
      _oprot.writeFieldBegin(DeviceField)
      device.get.write(_oprot)
      _oprot.writeFieldEnd()
    }
    if (deviceId ne null) {
      _oprot.writeFieldBegin(DeviceIdField)
      _oprot.writeString(deviceId)
      _oprot.writeFieldEnd()
    }
    if (userId.isDefined) {
      _oprot.writeFieldBegin(UserIdField)
      _oprot.writeString(userId.get)
      _oprot.writeFieldEnd()
    }
    if (obsoleteKruxId.isDefined) {
      _oprot.writeFieldBegin(ObsoleteKruxIdField)
      _oprot.writeString(obsoleteKruxId.get)
      _oprot.writeFieldEnd()
    }
    if (subscriptionId.isDefined) {
      _oprot.writeFieldBegin(SubscriptionIdFieldI32)
      _oprot.writeI32(subscriptionId.get.value)
      _oprot.writeFieldEnd()
    }
    if (events ne null) {
      _oprot.writeFieldBegin(EventsField)
      writeEventsValue(_oprot, events)
      _oprot.writeFieldEnd()
    }
    if (membershipTier.isDefined) {
      _oprot.writeFieldBegin(MembershipTierFieldI32)
      _oprot.writeI32(membershipTier.get.value)
      _oprot.writeFieldEnd()
    }
    _root_.com.twitter.scrooge.internal.TProtocols.finishWritingStruct(_oprot, _passthroughFields)
  }

  def copy(
    app: ophan.thrift.nativeapp.App = this.app,
    device: _root_.scala.Option[ophan.thrift.nativeapp.Device] = this.device,
    deviceId: String = this.deviceId,
    userId: _root_.scala.Option[String] = this.userId,
    obsoleteKruxId: _root_.scala.Option[String] = this.obsoleteKruxId,
    subscriptionId: _root_.scala.Option[ophan.thrift.subscription.SubscriptionType] = this.subscriptionId,
    events: _root_.scala.collection.Seq[ophan.thrift.nativeapp.Event] = this.events,
    membershipTier: _root_.scala.Option[ophan.thrift.subscription.MembershipTier] = this.membershipTier,
    _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
  ): NativeAppSubmission =
    new Immutable(
      app,
      device,
      deviceId,
      userId,
      obsoleteKruxId,
      subscriptionId,
      events,
      membershipTier,
      _passthroughFields
    )

  override def canEqual(other: Any): Boolean = other.isInstanceOf[NativeAppSubmission]

  private[this] def _equals(other: NativeAppSubmission): Boolean =
      this.productArity == other.productArity &&
      this.productIterator.sameElements(other.productIterator) &&
      this._passthroughFields == other._passthroughFields

  override def equals(other: Any): Boolean =
    canEqual(other) && _equals(other.asInstanceOf[NativeAppSubmission])

  override def hashCode: Int = {
    _root_.scala.runtime.ScalaRunTime._hashCode(this)
  }

  override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)

  override def productPrefix: String = "NativeAppSubmission"

  def _codec: ValidatingThriftStructCodec3[NativeAppSubmission] = NativeAppSubmission

  def newBuilder(): StructBuilder[NativeAppSubmission] = new NativeAppSubmissionStructBuilder(_root_.scala.Some(this), fieldTypes)
}

private[nativeapp] class NativeAppSubmissionStructBuilder(instance: _root_.scala.Option[NativeAppSubmission], fieldTypes: IndexedSeq[ClassTag[_]])
    extends StructBuilder[NativeAppSubmission](fieldTypes) {

  def build(): NativeAppSubmission = {
    val _fieldArray = fieldArray // shadow variable
    if (instance.isDefined) {
      val instanceValue = instance.get
      NativeAppSubmission(
        if (_fieldArray(0) == null) instanceValue.app else _fieldArray(0).asInstanceOf[ophan.thrift.nativeapp.App],
        if (_fieldArray(1) == null) instanceValue.device else _fieldArray(1).asInstanceOf[_root_.scala.Option[ophan.thrift.nativeapp.Device]],
        if (_fieldArray(2) == null) instanceValue.deviceId else _fieldArray(2).asInstanceOf[String],
        if (_fieldArray(3) == null) instanceValue.userId else _fieldArray(3).asInstanceOf[_root_.scala.Option[String]],
        if (_fieldArray(4) == null) instanceValue.obsoleteKruxId else _fieldArray(4).asInstanceOf[_root_.scala.Option[String]],
        if (_fieldArray(5) == null) instanceValue.subscriptionId else _fieldArray(5).asInstanceOf[_root_.scala.Option[ophan.thrift.subscription.SubscriptionType]],
        if (_fieldArray(6) == null) instanceValue.events else _fieldArray(6).asInstanceOf[_root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]],
        if (_fieldArray(7) == null) instanceValue.membershipTier else _fieldArray(7).asInstanceOf[_root_.scala.Option[ophan.thrift.subscription.MembershipTier]]
      )
    } else {
      if (genericArrayOps(_fieldArray).contains(null)) throw new InvalidFieldsException(structBuildError("NativeAppSubmission"))
      NativeAppSubmission(
        _fieldArray(0).asInstanceOf[ophan.thrift.nativeapp.App],
        _fieldArray(1).asInstanceOf[_root_.scala.Option[ophan.thrift.nativeapp.Device]],
        _fieldArray(2).asInstanceOf[String],
        _fieldArray(3).asInstanceOf[_root_.scala.Option[String]],
        _fieldArray(4).asInstanceOf[_root_.scala.Option[String]],
        _fieldArray(5).asInstanceOf[_root_.scala.Option[ophan.thrift.subscription.SubscriptionType]],
        _fieldArray(6).asInstanceOf[_root_.scala.collection.Seq[ophan.thrift.nativeapp.Event]],
        _fieldArray(7).asInstanceOf[_root_.scala.Option[ophan.thrift.subscription.MembershipTier]]
      )
    }
  }
}

