/*
 * Decompiled with CFR 0.152.
 */
package com.gu.pandomainauth;

import com.amazonaws.services.s3.AmazonS3;
import com.gu.pandomainauth.PanDomainAuthSettingsRefresher$;
import com.gu.pandomainauth.Settings$;
import com.gu.pandomainauth.SettingsFailure;
import com.gu.pandomainauth.model.PanDomainAuthSettings;
import com.gu.pandomainauth.model.PanDomainAuthSettings$;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001B\f\u0019\u0001}A\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\tg\u0001\u0011\t\u0011)A\u0005Q!AA\u0007\u0001BC\u0002\u0013\u0005q\u0005\u0003\u00056\u0001\t\u0005\t\u0015!\u0003)\u0011!1\u0004A!b\u0001\n\u00039\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011a\u0002!\u0011!Q\u0001\n!B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005w!Aa\t\u0001B\u0001B\u0003%q\tC\u0003R\u0001\u0011\u0005!\u000bC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r\u0015\u0004\u0001\u0015!\u0003^\u0011\u001d1\u0007A1A\u0005\n\u001dDa\u0001\u001e\u0001!\u0002\u0013A\u0007\"B;\u0001\t\u00031\b\"B<\u0001\t\u0013A\bbBA\t\u0001\u0011%\u00111C\u0004\n\u00037A\u0012\u0011!E\u0001\u0003;1\u0001b\u0006\r\u0002\u0002#\u0005\u0011q\u0004\u0005\u0007#R!\t!!\t\t\u0013\u0005\rB#%A\u0005\u0002\u0005\u0015\"A\b)b]\u0012{W.Y5o\u0003V$\bnU3ui&twm\u001d*fMJ,7\u000f[3s\u0015\tI\"$A\u0007qC:$w.\\1j]\u0006,H\u000f\u001b\u0006\u00037q\t!aZ;\u000b\u0003u\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019!w.\\1j]V\t\u0001\u0006\u0005\u0002*a9\u0011!F\f\t\u0003W\tj\u0011\u0001\f\u0006\u0003[y\ta\u0001\u0010:p_Rt\u0014BA\u0018#\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u0012\u0013a\u00023p[\u0006Lg\u000eI\u0001\u0007gf\u001cH/Z7\u0002\u000fML8\u000f^3nA\u0005Q!-^2lKRt\u0015-\\3\u0002\u0017\t,8m[3u\u001d\u0006lW\rI\u0001\u0010g\u0016$H/\u001b8hg\u001aKG.Z&fs\u0006A1oM\"mS\u0016tG/F\u0001<!\ta4)D\u0001>\u0015\tqt(\u0001\u0002tg)\u0011\u0001)Q\u0001\tg\u0016\u0014h/[2fg*\u0011!\tH\u0001\nC6\f'p\u001c8boNL!\u0001R\u001f\u0003\u0011\u0005k\u0017M_8o'N\n\u0011b]\u001aDY&,g\u000e\u001e\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001%P\u001b\u0005I%B\u0001&L\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u00196\u000bA!\u001e;jY*\ta*\u0001\u0003kCZ\f\u0017B\u0001)J\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fM+fk\u0016-Z5B\u0011A\u000bA\u0007\u00021!)ae\u0003a\u0001Q!)Ag\u0003a\u0001Q!)ag\u0003a\u0001Q!)\u0001h\u0003a\u0001Q!)\u0011h\u0003a\u0001w!9ai\u0003I\u0001\u0002\u00049\u0015A\u00027pO\u001e,'/F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0003tY\u001a$$NC\u0001c\u0003\ry'oZ\u0005\u0003I~\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\rCV$\bnU3ui&twm]\u000b\u0002QB\u0019\u0011\u000e\u001c8\u000e\u0003)T!a[%\u0002\r\u0005$x.\\5d\u0013\ti'NA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\ty'/D\u0001q\u0015\t\t\b$A\u0003n_\u0012,G.\u0003\u0002ta\n)\u0002+\u00198E_6\f\u0017N\\!vi\"\u001cV\r\u001e;j]\u001e\u001c\u0018!D1vi\"\u001cV\r\u001e;j]\u001e\u001c\b%\u0001\u0005tKR$\u0018N\\4t+\u0005q\u0017\u0001\u00047pC\u0012\u001cV\r\u001e;j]\u001e\u001cH#A=\u0011\ri|\u0018QAA\u0006\u001d\tYXP\u0004\u0002,y&\t1%\u0003\u0002\u007fE\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u0011a!R5uQ\u0016\u0014(B\u0001@#!\r!\u0016qA\u0005\u0004\u0003\u0013A\"aD*fiRLgnZ:GC&dWO]3\u0011\u000b%\ni\u0001\u000b\u0015\n\u0007\u0005=!GA\u0002NCB\fqA]3ge\u0016\u001c\b\u000e\u0006\u0002\u0002\u0016A\u0019\u0011%a\u0006\n\u0007\u0005e!E\u0001\u0003V]&$\u0018A\b)b]\u0012{W.Y5o\u0003V$\bnU3ui&twm\u001d*fMJ,7\u000f[3s!\t!Fc\u0005\u0002\u0015AQ\u0011\u0011QD\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005\u001d\"fA$\u0002*-\u0012\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%)hn\u00195fG.,GMC\u0002\u00026\t\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI$a\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class PanDomainAuthSettingsRefresher {
    private final String domain;
    private final String system;
    private final String bucketName;
    private final String settingsFileKey;
    private final AmazonS3 s3Client;
    private final Logger logger;
    private final AtomicReference<PanDomainAuthSettings> authSettings;

    public static ScheduledExecutorService $lessinit$greater$default$6() {
        return PanDomainAuthSettingsRefresher$.MODULE$.$lessinit$greater$default$6();
    }

    public String domain() {
        return this.domain;
    }

    public String system() {
        return this.system;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public AmazonS3 s3Client() {
        return this.s3Client;
    }

    private Logger logger() {
        return this.logger;
    }

    private AtomicReference<PanDomainAuthSettings> authSettings() {
        return this.authSettings;
    }

    public PanDomainAuthSettings settings() {
        return this.authSettings().get();
    }

    private Either<SettingsFailure, Map<String, String>> loadSettings() {
        return Settings$.MODULE$.fetchSettings(this.settingsFileKey, this.bucketName(), this.s3Client()).flatMap((Function1 & Serializable)settingsBody -> Settings$.MODULE$.extractSettings(settingsBody));
    }

    private void refresh() {
        Either<SettingsFailure, Map<String, String>> either = this.loadSettings();
        if (either instanceof Right) {
            Right right = (Right)either;
            Map settings = (Map)right.value();
            this.logger().debug(new StringBuilder(32).append("Updated pan-domain settings for ").append(this.domain()).toString());
            this.authSettings().set(PanDomainAuthSettings$.MODULE$.apply((Map<String, String>)settings));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Left) {
            Left left = (Left)either;
            SettingsFailure err = (SettingsFailure)left.value();
            this.logger().error(new StringBuilder(41).append("Failed to update pan-domain settings for ").append(this.domain()).toString());
            Settings$.MODULE$.logError(err, this.logger());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
    }

    public PanDomainAuthSettingsRefresher(String domain, String system, String bucketName, String settingsFileKey, AmazonS3 s3Client, ScheduledExecutorService scheduler) {
        this.domain = domain;
        this.system = system;
        this.bucketName = bucketName;
        this.settingsFileKey = settingsFileKey;
        this.s3Client = s3Client;
        this.logger = LoggerFactory.getLogger(this.getClass());
        Either<SettingsFailure, Map<String, String>> either = this.loadSettings();
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                SettingsFailure err = (SettingsFailure)left.value();
                throw Settings$.MODULE$.errorToThrowable(err);
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Map settings = (Map)right.value();
        PanDomainAuthSettings panDomainAuthSettings = PanDomainAuthSettings$.MODULE$.apply((Map<String, String>)settings);
        this.authSettings = new AtomicReference<PanDomainAuthSettings>(panDomainAuthSettings);
        scheduler.scheduleAtFixedRate(() -> this.refresh(), 1L, 1L, TimeUnit.MINUTES);
    }
}

