/*
 * Decompiled with CFR 0.152.
 */
package com.gu.pandomainauth;

import com.gu.pandomainauth.PublicSettings;
import com.gu.pandomainauth.PublicSettings$PublicKeyFormatException$;
import com.gu.pandomainauth.PublicSettings$PublicKeyNotFoundException$;
import com.gu.pandomainauth.package;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;

public final class PublicSettings$ {
    public static PublicSettings$ MODULE$;
    private final String bucketName;
    private final String cookieName;
    private final String assymCookieName;
    private final Map<JobKey, Function0<BoxedUnit>> com$gu$pandomainauth$PublicSettings$$jobs;

    static {
        new PublicSettings$();
    }

    public Function1<Try<scala.collection.immutable.Map<String, String>>, BoxedUnit> $lessinit$greater$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> {
            PublicSettings$.$anonfun$$lessinit$greater$default$2$1(x$1);
            return BoxedUnit.UNIT;
        };
    }

    public Scheduler $lessinit$greater$default$3() {
        return StdSchedulerFactory.getDefaultScheduler();
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String cookieName() {
        return this.cookieName;
    }

    public String assymCookieName() {
        return this.assymCookieName;
    }

    public Future<scala.collection.immutable.Map<String, String>> getPublicSettings(String domain, OkHttpClient client, ExecutionContext ec) {
        return this.fetchSettings(domain, client, ec).flatMap((Function1 & Serializable & scala.Serializable)settingsAttempt -> MODULE$.extractSettings((Either<Throwable, String>)settingsAttempt), ec);
    }

    public Future<String> getPublicKey(String domain, OkHttpClient client, ExecutionContext ec) {
        return this.getPublicSettings(domain, client, ec).flatMap((Function1 & Serializable & scala.Serializable)settings -> MODULE$.extractPublicKey((scala.collection.immutable.Map<String, String>)settings), ec);
    }

    private Future<Either<Throwable, String>> fetchSettings(String domain, OkHttpClient client, ExecutionContext ec) {
        Promise promise = Promise$.MODULE$.apply();
        Request req = new Request.Builder().url(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://s3-eu-west-1.amazonaws.com/", "/", ".settings.public"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bucketName(), domain}))).build();
        client.newCall(req).enqueue(new Callback(promise){
            private final Promise promise$1;

            public void onFailure(Call call, IOException e) {
                this.promise$1.success((Object)package$.MODULE$.Left().apply((Object)e));
            }

            public void onResponse(Call call, Response response) {
                this.promise$1.success((Object)package$.MODULE$.Right().apply((Object)response.body().string()));
            }
            {
                this.promise$1 = promise$1;
            }
        });
        return promise.future();
    }

    public Future<scala.collection.immutable.Map<String, String>> extractSettings(Either<Throwable, String> settingsAttempt) {
        Future future;
        Either<Throwable, String> either = settingsAttempt;
        if (either instanceof Right) {
            Right right = (Right)either;
            String settingsBody = (String)right.value();
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(settingsBody.getBytes("UTF-8")));
            future = Future$.MODULE$.successful((Object)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.$conforms()));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Throwable err = (Throwable)left.value();
            future = Future$.MODULE$.failed((Throwable)new PublicSettings.PublicSettingsAcquisitionException(err));
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    public Future<String> extractPublicKey(scala.collection.immutable.Map<String, String> settings) {
        Future future;
        Either either = settings.get((Object)"publicKey").toRight((Function0 & Serializable & scala.Serializable)() -> PublicSettings$PublicKeyNotFoundException$.MODULE$).right().flatMap((Function1 & Serializable & scala.Serializable)rawKey -> MODULE$.validateKey((String)rawKey).right().map((Function1 & Serializable & scala.Serializable)publicKey -> new package.PublicKey(((package.PublicKey)publicKey).key())));
        if (either instanceof Right) {
            Right right = (Right)either;
            String publicKey = ((package.PublicKey)right.value()).key();
            future = Future$.MODULE$.successful((Object)new package.PublicKey(publicKey));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Throwable err = (Throwable)left.value();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)either);
        }
        return future;
    }

    public Either<Throwable, String> validateKey(String pubKey) {
        return new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z0-9+/\n]+={0,3}")).r().pattern().matcher(pubKey).matches() ? package$.MODULE$.Right().apply((Object)new package.PublicKey(pubKey)) : package$.MODULE$.Left().apply((Object)PublicSettings$PublicKeyFormatException$.MODULE$);
    }

    public Map<JobKey, Function0<BoxedUnit>> com$gu$pandomainauth$PublicSettings$$jobs() {
        return this.com$gu$pandomainauth$PublicSettings$$jobs;
    }

    public static final /* synthetic */ void $anonfun$$lessinit$greater$default$2$1(Try x$1) {
    }

    private PublicSettings$() {
        MODULE$ = this;
        this.bucketName = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PANDA_BUCKET_NAME", (Function0 & Serializable & scala.Serializable)() -> "pan-domain-auth-settings");
        this.cookieName = "gutoolsAuth";
        this.assymCookieName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-assym"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cookieName()}));
        this.com$gu$pandomainauth$PublicSettings$$jobs = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

