/*
 * Decompiled with CFR 0.152.
 */
package com.gu.pandomainauth.service;

import com.gu.pandomainauth.model.AuthenticatedUser;
import com.gu.pandomainauth.model.CookieParseException;
import com.gu.pandomainauth.model.CookieSignatureInvalidException;
import com.gu.pandomainauth.model.User;
import com.gu.pandomainauth.service.Crypto$;
import java.io.Serializable;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class CookieUtils$ {
    public static CookieUtils$ MODULE$;
    private Regex CookieRegEx;
    private volatile boolean bitmap$0;

    static {
        new CookieUtils$();
    }

    public String serializeAuthenticatedUser(AuthenticatedUser authUser) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstName=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authUser.user().firstName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&lastName=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authUser.user().lastName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&email=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authUser.user().email()})) + authUser.user().avatarUrl().map((Function1 & Serializable & scala.Serializable)a -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&avatarUrl=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&system=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authUser.authenticatingSystem()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&authedIn=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authUser.authenticatedIn().mkString(",")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&expires=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)authUser.expires())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"&multifactor=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)authUser.multiFactor())}));
    }

    public AuthenticatedUser deserializeAuthenticatedUser(String serializedForm) {
        Map data = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedForm.split("&"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p[0]), (Object)p[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new AuthenticatedUser(new User((String)data.apply((Object)"firstName"), (String)data.apply((Object)"lastName"), (String)data.apply((Object)"email"), (Option<String>)data.get((Object)"avatarUrl")), (String)data.apply((Object)"system"), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((String)data.apply((Object)"authedIn")).split(",")))), new StringOps(Predef$.MODULE$.augmentString((String)data.apply((Object)"expires"))).toLong(), new StringOps(Predef$.MODULE$.augmentString((String)data.apply((Object)"multifactor"))).toBoolean());
    }

    public String generateCookieData(AuthenticatedUser authUser, String prvKey) {
        String data = this.serializeAuthenticatedUser(authUser);
        String encodedData = new String(Base64.encodeBase64((byte[])data.getBytes("UTF-8")));
        byte[] signature = Crypto$.MODULE$.signData(data.getBytes("UTF-8"), prvKey);
        String encodedSignature = new String(Base64.encodeBase64((byte[])signature));
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encodedData, encodedSignature}));
    }

    private Regex CookieRegEx$lzycompute() {
        CookieUtils$ cookieUtils$ = this;
        synchronized (cookieUtils$) {
            if (!this.bitmap$0) {
                this.CookieRegEx = new StringOps(Predef$.MODULE$.augmentString("^^([\\w\\W]*)\\.([\\w\\W]*)$")).r();
                this.bitmap$0 = true;
            }
        }
        return this.CookieRegEx;
    }

    public Regex CookieRegEx() {
        return !this.bitmap$0 ? this.CookieRegEx$lzycompute() : this.CookieRegEx;
    }

    public AuthenticatedUser parseCookieData(String cookieString, String pubKey) {
        AuthenticatedUser authenticatedUser;
        String string = cookieString;
        Option option = this.CookieRegEx().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String data = (String)((LinearSeqOptimized)option.get()).apply(0);
            String sig = (String)((LinearSeqOptimized)option.get()).apply(1);
            try {
                if (!Crypto$.MODULE$.verifySignature(Base64.decodeBase64((byte[])data.getBytes("UTF-8")), Base64.decodeBase64((byte[])sig.getBytes("UTF-8")), pubKey)) {
                    throw new CookieSignatureInvalidException();
                }
                authenticatedUser = this.deserializeAuthenticatedUser(new String(Base64.decodeBase64((byte[])data.getBytes("UTF-8"))));
            }
            catch (SignatureException e) {
                throw new CookieSignatureInvalidException();
            }
        } else {
            throw new CookieParseException();
        }
        AuthenticatedUser authenticatedUser2 = authenticatedUser;
        return authenticatedUser2;
    }

    private CookieUtils$() {
        MODULE$ = this;
    }
}

