/*
 * Decompiled with CFR 0.152.
 */
package com.guicedee.guicedservlets.undertow;

import com.guicedee.guicedinjection.GuiceContext;
import com.guicedee.guicedservlets.undertow.GuicedUndertowWebSocketConfiguration;
import com.guicedee.guicedservlets.undertow.services.UndertowDeploymentConfigurator;
import com.guicedee.logger.LogFactory;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.LearningPushHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.xnio.Xnio;

public class GuicedUndertow {
    private static final Logger log = LogFactory.getLog((String)"JWebMP Undertow");
    private String serverKeystore;
    private char[] storePassword;
    private Class sslStoreReferenceClass;
    private boolean http2 = true;
    private String host;
    private int port;
    private boolean ssl;
    private String sslKeyLocation;
    private String serverTruststoreLocation;
    private KeyStore sslKeystore;
    private KeyStore trustKeystore;
    private Undertow.Builder server = Undertow.builder();

    public static Undertow boot(String host, int port, boolean ssl, String serverKeystore, String serverTruststore, String sslKey, char[] sslPassword, Class referenceClass, boolean http2) throws Exception {
        GuicedUndertow undertow = new GuicedUndertow();
        undertow.host = host;
        undertow.port = port;
        undertow.ssl = ssl;
        undertow.sslKeyLocation = sslKey;
        undertow.storePassword = sslPassword;
        undertow.sslStoreReferenceClass = referenceClass;
        undertow.http2 = http2;
        undertow.serverKeystore = serverKeystore;
        undertow.serverTruststoreLocation = serverTruststore;
        return undertow.bootMe();
    }

    public Undertow bootMe() throws Exception {
        SSLContext sslContext = null;
        if (this.ssl) {
            sslContext = this.sslKeystore == null ? GuicedUndertow.createSSLContext(GuicedUndertow.loadKeyStore(this.sslStoreReferenceClass, this.serverKeystore, this.storePassword), GuicedUndertow.loadKeyStore(this.sslStoreReferenceClass, this.serverTruststoreLocation, this.storePassword), this.storePassword) : GuicedUndertow.createSSLContext(this.sslKeystore, this.trustKeystore, this.storePassword);
        }
        log.fine("Setting XNIO Provider : " + Xnio.getInstance().getName());
        if (this.http2) {
            this.server.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
            this.server.setServerOption(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH, (Object)true);
        }
        if (this.ssl) {
            this.server.addHttpsListener(this.port, this.host, sslContext);
        } else {
            this.server.addHttpListener(this.port, this.host);
        }
        DeploymentInfo deploymentInfo = Servlets.deployment().setClassLoader(GuicedUndertow.class.getClassLoader()).setContextPath("/").setDeploymentName(this.host + "-" + this.port + ".war");
        ServiceLoader.load(UndertowDeploymentConfigurator.class);
        for (UndertowDeploymentConfigurator config : ServiceLoader.load(UndertowDeploymentConfigurator.class)) {
            deploymentInfo = config.configure(deploymentInfo);
        }
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(deploymentInfo);
        GuiceContext.inject();
        manager.deploy();
        HttpHandler jwebSwingHandler = manager.start();
        HttpHandler encodingHandler = new EncodingHandler.Builder().build(null).wrap(jwebSwingHandler);
        PathHandler ph = GuicedUndertowWebSocketConfiguration.getWebSocketHandler() != null ? Handlers.path().addPrefixPath("/wssocket", GuicedUndertowWebSocketConfiguration.getWebSocketHandler()).addPrefixPath("/", encodingHandler) : Handlers.path().addPrefixPath("/", encodingHandler);
        this.server.setHandler((HttpHandler)new SessionAttachmentHandler((HttpHandler)new LearningPushHandler(100, -1, (HttpHandler)Handlers.header((HttpHandler)ph, (String)"x-undertow-transport", (ExchangeAttribute)ExchangeAttributes.transportProtocol())), (SessionManager)new InMemorySessionManager("sessionManager"), (SessionConfig)new SessionCookieConfig().setSecure(true).setHttpOnly(true)));
        Undertow u = this.server.build();
        u.start();
        return u;
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore, char[] password) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public static KeyStore loadKeyStore(Class referencePath, String name, char[] password) throws Exception {
        String storeLoc = System.getProperty(name);
        InputStream stream = storeLoc == null ? referencePath.getResourceAsStream(name) : Files.newInputStream(Paths.get(storeLoc, new String[0]), new OpenOption[0]);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try (InputStream is = stream;){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(is, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
    }

    public static Undertow boot(String host, int port, boolean ssl, KeyStore serverKeystore, KeyStore serverTruststore, String sslKey, char[] sslPassword, Class referenceClass, boolean http2) throws Exception {
        GuicedUndertow undertow = new GuicedUndertow();
        undertow.host = host;
        undertow.port = port;
        undertow.ssl = ssl;
        undertow.sslKeyLocation = sslKey;
        undertow.storePassword = sslPassword;
        undertow.sslStoreReferenceClass = referenceClass;
        undertow.http2 = http2;
        undertow.sslKeystore = serverKeystore;
        undertow.trustKeystore = serverTruststore;
        return undertow.bootMe();
    }

    public static Undertow boot(String host, int port) throws Exception {
        GuicedUndertow undertow = new GuicedUndertow();
        undertow.host = host;
        undertow.port = port;
        return undertow.bootMe();
    }

    public String getServerKeystore() {
        return this.serverKeystore;
    }

    public GuicedUndertow setServerKeystore(String serverKeystore) {
        this.serverKeystore = serverKeystore;
        return this;
    }

    public char[] getStorePassword() {
        return this.storePassword;
    }

    public GuicedUndertow setStorePassword(char[] storePassword) {
        this.storePassword = storePassword;
        return this;
    }

    public Class getSslStoreReferenceClass() {
        return this.sslStoreReferenceClass;
    }

    public GuicedUndertow setSSLStoresReferenceClass(Class referenceClass) {
        this.sslStoreReferenceClass = referenceClass;
        return this;
    }

    public boolean isHttp2() {
        return this.http2;
    }

    public GuicedUndertow setHttp2(boolean http2) {
        this.http2 = http2;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public GuicedUndertow setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public GuicedUndertow setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public GuicedUndertow setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public String getSslKeyLocation() {
        return this.sslKeyLocation;
    }

    public GuicedUndertow setSslKeyLocation(String sslKeyLocation) {
        this.sslKeyLocation = sslKeyLocation;
        return this;
    }

    public String getServerTruststoreLocation() {
        return this.serverTruststoreLocation;
    }

    public GuicedUndertow setServerTruststoreLocation(String serverTruststoreLocation) {
        this.serverTruststoreLocation = serverTruststoreLocation;
        return this;
    }

    public KeyStore getSslKeystore() {
        return this.sslKeystore;
    }

    public GuicedUndertow setSslKeystore(KeyStore sslKeystore) {
        this.sslKeystore = sslKeystore;
        return this;
    }

    public KeyStore getTrustKeystore() {
        return this.trustKeystore;
    }

    public GuicedUndertow setTrustKeystore(KeyStore trustKeystore) {
        this.trustKeystore = trustKeystore;
        return this;
    }

    public Undertow.Builder getServer() {
        return this.server;
    }

    public void setServer(Undertow.Builder server) {
        this.server = server;
    }
}

