/*
 * Decompiled with CFR 0.152.
 */
package com.guicedee.guicedservlets.undertow;

import com.guicedee.guicedinjection.GuiceContext;
import com.guicedee.logger.LogFactory;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class GuicedUndertowResourceManager
extends ClassPathResourceManager {
    private static final Set<String> blacklistCriteria = new HashSet<String>();
    private static String[] resourceLocations = new String[]{"", "META-INF/resources/"};
    private ClassLoader classLoader;

    private ScanResult getScanResult() {
        return GuiceContext.instance().getScanResult();
    }

    public GuicedUndertowResourceManager(ClassLoader loader, Package p) {
        super(loader, p);
    }

    public GuicedUndertowResourceManager(ClassLoader classLoader, String prefix) {
        super(classLoader, prefix);
    }

    public GuicedUndertowResourceManager(ClassLoader classLoader) {
        super(classLoader, "/");
        this.classLoader = classLoader;
    }

    public io.undertow.server.handlers.resource.Resource getResource(String path) throws IOException {
        if ("/RES_NOT_FOUND".equals(path)) {
            System.out.println("Resource not found!");
        }
        String pathOriginal = path;
        String pathExt = null;
        if (path.indexOf(46) < 0) {
            return super.getResource(path);
        }
        pathExt = path.substring(path.lastIndexOf(46));
        if (blacklistCriteria.contains(pathExt.toLowerCase())) {
            throw new IOException("Blacklisted Fetch : " + path);
        }
        try {
            for (String resourceLocation : resourceLocations) {
                ResourceList resources = this.getScanResult().getResourcesWithPath(resourceLocation + path);
                if (resources == null) continue;
                for (Resource resource : resources) {
                    URL url = resource.getURL();
                    if (url == null) {
                        LogFactory.getLog(((Object)((Object)this)).getClass()).log(Level.SEVERE, "Cannot find through scan result -" + pathOriginal);
                        continue;
                    }
                    if (url.toString().contains("jrt:/")) {
                        URI uri = URI.create(url.toString());
                        return new URLResource(uri.toURL(), pathOriginal);
                    }
                    return new URLResource(resource.getURL(), pathOriginal);
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).log(Level.FINE, "No scan result -" + pathOriginal, e);
        }
        io.undertow.server.handlers.resource.Resource r = super.getResource(pathOriginal);
        if (r == null) {
            r = new ClassPathResourceManager(this.classLoader, "META-INF/resources/").getResource(pathOriginal);
        }
        if (r == null && pathOriginal.startsWith("/resources/")) {
            String newPathOriginal = pathOriginal.replaceFirst("/resources/", "");
            r = this.getResource(newPathOriginal);
            if (r == null) {
                System.out.println("Not found resource : " + pathOriginal);
            }
            return r;
        }
        return r;
    }

    static {
        blacklistCriteria.add(".class");
    }
}

