/*
 * Decompiled with CFR 0.152.
 */
package com.guicedee.guicedservlets.undertow;

import com.guicedee.guicedservlets.websockets.GuicedWebSocket;
import com.guicedee.guicedservlets.websockets.services.IWebSocketPreConfiguration;
import com.guicedee.logger.LogFactory;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class GuicedUndertowWebSocketConfiguration
implements IWebSocketPreConfiguration<GuicedUndertowWebSocketConfiguration> {
    private static final Logger log = LogFactory.getLog((String)"UndertowWebSockets");
    private static WebSocketDeploymentInfo webSocketDeploymentInfo;
    private static HttpHandler webSocketHandler;

    public static WebSocketDeploymentInfo getWebSocketDeploymentInfo() {
        return webSocketDeploymentInfo;
    }

    public static HttpHandler getWebSocketHandler() {
        return webSocketHandler;
    }

    public void configure() {
        log.config("Setting up XNIO for Websockets at /wssocket");
        Xnio xnio = Xnio.getInstance((String)"nio");
        try {
            XnioWorker xnioWorker = xnio.createWorker(OptionMap.builder().getMap());
            webSocketDeploymentInfo = new WebSocketDeploymentInfo().addEndpoint(GuicedWebSocket.class).setWorker(xnioWorker);
            DeploymentInfo websocketDeployment = Servlets.deployment().setContextPath("/wssocket").addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo).setDeploymentName("websocket-deployment").setClassLoader(Thread.currentThread().getContextClassLoader());
            DeploymentManager manager = Servlets.defaultContainer().addDeployment(websocketDeployment);
            manager.deploy();
            log.fine("Registering WebSockets in Undertow - [/wssocket]");
            webSocketHandler = manager.start();
            log.fine("Completed WebSocket [/wssocket]");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to configure XNIO with WebSocket Handler", e);
        }
    }

    public boolean enabled() {
        return true;
    }
}

