/*
 * Decompiled with CFR 0.152.
 */
package com.guicedee.guicedservlets.undertow;

import com.guicedee.guicedinjection.GuiceContext;
import com.guicedee.guicedservlets.GuicedFilter;
import com.guicedee.guicedservlets.GuicedServletContextListener;
import com.guicedee.guicedservlets.GuicedServletSessionManager;
import com.guicedee.guicedservlets.undertow.GuicedUndertowResourceManager;
import com.guicedee.logger.LogFactory;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;

public class UndertowGuicedHandlerExtension
implements ServletExtension {
    private static final Logger log = LogFactory.getLog((String)"GuicedUndertow");

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (servletContext.getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo") == null) {
            log.fine("Registering Guice Filter in Undertow");
            ImmediateInstanceFactory guicedContextInstanceFactory = new ImmediateInstanceFactory(GuiceContext.get(GuicedServletContextListener.class));
            ImmediateInstanceFactory guiceInstanceFactory = new ImmediateInstanceFactory(GuiceContext.get(GuicedServletSessionManager.class));
            ImmediateInstanceFactory guiceFilterFactory = new ImmediateInstanceFactory(GuiceContext.get(GuicedFilter.class));
            deploymentInfo.addFilter(new FilterInfo("GuiceUndertowFilter", GuicedFilter.class, (InstanceFactory)guiceFilterFactory).setAsyncSupported(true));
            deploymentInfo.addFilterUrlMapping("GuiceUndertowFilter", "/*", DispatcherType.REQUEST);
            deploymentInfo.addListener(new ListenerInfo(GuicedServletContextListener.class, (InstanceFactory)guicedContextInstanceFactory));
            deploymentInfo.addListener(new ListenerInfo(GuicedServletSessionManager.class, (InstanceFactory)guiceInstanceFactory));
        } else {
            log.fine("Requested to configure guice for web sockets - skipped. - " + deploymentInfo.getDeploymentName());
        }
        log.config("Configuring Resources to be found by GuicedUndertowResourceManager");
        deploymentInfo.setResourceManager((ResourceManager)new GuicedUndertowResourceManager(classLoader));
        log.fine("Undertow Configured");
    }
}

