/*
 * Decompiled with CFR 0.152.
 */
package com.guicedee.guicedservlets.undertow;

import com.guicedee.guicedinjection.GuiceContext;
import com.guicedee.guicedservlets.undertow.GuicedUndertowWebSocketConfiguration;
import com.guicedee.guicedservlets.undertow.services.UndertowDeploymentConfigurator;
import com.guicedee.logger.LogFactory;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.LearningPushHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.xnio.Xnio;

public class GuicedUndertow {
    private static final Logger log = LogFactory.getLog((String)"JWebMP Undertow");
    private String serverKeystore;
    private char[] storePassword;
    private Class referenceClass;
    private boolean http2 = true;
    private String host;
    private int port;
    private boolean ssl;
    private String sslKey;
    private String serverTruststore;

    public static Undertow boot(String host, int port, boolean ssl, String serverKeystore, String serverTruststore, String sslKey, char[] sslPassword, Class referenceClass, boolean http2) throws Exception {
        GuicedUndertow undertow = new GuicedUndertow();
        undertow.host = host;
        undertow.port = port;
        undertow.ssl = ssl;
        undertow.sslKey = sslKey;
        undertow.storePassword = sslPassword;
        undertow.referenceClass = referenceClass;
        undertow.http2 = http2;
        undertow.serverKeystore = serverKeystore;
        undertow.serverTruststore = serverTruststore;
        return undertow.bootMe();
    }

    private Undertow bootMe() throws Exception {
        SSLContext sslContext = null;
        if (this.ssl) {
            sslContext = GuicedUndertow.createSSLContext(GuicedUndertow.loadKeyStore(this.referenceClass, this.serverKeystore, this.storePassword), GuicedUndertow.loadKeyStore(this.referenceClass, this.serverTruststore, this.storePassword), this.storePassword);
        }
        log.config("Setting XNIO Provider : " + Xnio.getInstance().getName());
        Undertow.Builder server = Undertow.builder();
        if (this.http2) {
            server.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
            server.setServerOption(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH, (Object)true);
        }
        if (this.ssl) {
            server.addHttpsListener(this.port, this.host, sslContext);
        } else {
            server.addHttpListener(this.port, this.host);
        }
        DeploymentInfo deploymentInfo = Servlets.deployment().setClassLoader(GuicedUndertow.class.getClassLoader()).setContextPath("/").setDeploymentName(this.host + "-" + this.port + ".war");
        ServiceLoader.load(UndertowDeploymentConfigurator.class);
        for (UndertowDeploymentConfigurator config : ServiceLoader.load(UndertowDeploymentConfigurator.class)) {
            deploymentInfo = config.configure(deploymentInfo);
        }
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(deploymentInfo);
        GuiceContext.inject();
        manager.deploy();
        HttpHandler jwebSwingHandler = manager.start();
        HttpHandler encodingHandler = new EncodingHandler.Builder().build(null).wrap(jwebSwingHandler);
        PathHandler ph = GuicedUndertowWebSocketConfiguration.getWebSocketHandler() != null ? Handlers.path().addPrefixPath("/wssocket", GuicedUndertowWebSocketConfiguration.getWebSocketHandler()).addPrefixPath("/", encodingHandler) : Handlers.path().addPrefixPath("/", encodingHandler);
        server.setHandler((HttpHandler)new SessionAttachmentHandler((HttpHandler)new LearningPushHandler(100, -1, (HttpHandler)Handlers.header((HttpHandler)ph, (String)"x-undertow-transport", (ExchangeAttribute)ExchangeAttributes.transportProtocol())), (SessionManager)new InMemorySessionManager("sessionManager"), (SessionConfig)new SessionCookieConfig().setSecure(true).setHttpOnly(true)));
        Undertow u = server.build();
        u.start();
        return u;
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore, char[] password) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private static KeyStore loadKeyStore(Class referencePath, String name, char[] password) throws Exception {
        String storeLoc = System.getProperty(name);
        InputStream stream = storeLoc == null ? referencePath.getResourceAsStream(name) : Files.newInputStream(Paths.get(storeLoc, new String[0]), new OpenOption[0]);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try (InputStream is = stream;){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(is, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
    }

    public static Undertow boot(String host, int port) throws Exception {
        GuicedUndertow undertow = new GuicedUndertow();
        undertow.host = host;
        undertow.port = port;
        return undertow.bootMe();
    }
}

