/*
 * Decompiled with CFR 0.152.
 */
package com.att.XPlugin.LogPlugin.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.mycomm.MyConveyor.core.MyConveyor;
import com.mycomm.MyConveyor.core.TaskRequest;
import com.mycomm.MyConveyor.core.TaskType;
import com.mycomm.MyConveyor.core.Tasker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

class MyLogUtil {
    private static final String log_flag_runtime = "d33600715c5e79c155e268fbf99556tt.txt";
    private static int log_flag = -100;
    private static boolean log_runtime_switcher;
    private static final Boolean MYLOG_SWITCH;
    private static final Boolean MYLOG_WRITE_TO_FILE;
    private static final char MYLOG_TYPE = 'v';
    private static String MYLOG_PATH_SDCARD_DIR;
    private static final int SDCARD_LOG_FILE_SAVE_DAYS = 0;
    private static final String MYLOGFILEName = "-Log.txt.log";
    private static final SimpleDateFormat MYLOGSDF;
    private static final SimpleDateFormat logfile;

    MyLogUtil() {
    }

    public static void w(Context context, String tag, Object msg) {
        MyLogUtil.log(context, tag, msg.toString(), 'w');
    }

    public static void e(Context context, String tag, Object msg) {
        MyLogUtil.log(context, tag, msg.toString(), 'e');
    }

    public static void d(Context context, String tag, Object msg) {
        MyLogUtil.log(context, tag, msg.toString(), 'd');
    }

    public static void i(Context context, String tag, Object msg) {
        MyLogUtil.log(context, tag, msg.toString(), 'i');
    }

    public static void v(Context context, String tag, Object msg) {
        MyLogUtil.log(context, tag, msg.toString(), 'v');
    }

    public static void w(Context context, String tag, String text) {
        MyLogUtil.log(context, tag, text, 'w');
    }

    public static void e(Context context, String tag, String text) {
        MyLogUtil.log(context, tag, text, 'e');
    }

    public static void d(Context context, String tag, String text) {
        MyLogUtil.log(context, tag, text, 'd');
    }

    public static void i(Context context, String tag, String text) {
        MyLogUtil.log(context, tag, text, 'i');
    }

    public static void v(Context context, String tag, String text) {
        MyLogUtil.log(context, tag, text, 'v');
    }

    private static void log(Context context, final String tag, final String msg, final char level) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        if (MYLOG_SWITCH.booleanValue()) {
            if ('e' == level) {
                Log.e((String)tag, (String)msg);
            } else if ('w' == level) {
                Log.w((String)tag, (String)msg);
            } else if ('d' == level) {
                Log.d((String)tag, (String)msg);
            } else if ('i' == level) {
                Log.i((String)tag, (String)msg);
            } else {
                Log.v((String)tag, (String)msg);
            }
            if (MYLOG_WRITE_TO_FILE.booleanValue()) {
                if (log_flag == -100) {
                    log_flag = 1;
                    if (MyLogUtil.isFlagExist(context)) {
                        log_runtime_switcher = true;
                    } else {
                        return;
                    }
                }
                if (!log_runtime_switcher) {
                    return;
                }
                if (msg == null) {
                    return;
                }
                MyLogUtil.executeLogTask(new Tasker(){

                    public void onTask() {
                        MyLogUtil.writeLogtoFile(String.valueOf(level), tag, msg);
                    }
                });
            }
        }
    }

    private static boolean isFlagExist(Context context) {
        if (context == null) {
            return false;
        }
        boolean isCardExist = "mounted".equals(Environment.getExternalStorageState());
        if (!isCardExist) {
            return false;
        }
        File f = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + log_flag_runtime);
        if (f.exists()) {
            if (MYLOG_PATH_SDCARD_DIR == null) {
                String baseFilePath = context.getExternalFilesDir("mylog").getAbsolutePath();
                if (!baseFilePath.endsWith(File.separator)) {
                    baseFilePath = baseFilePath + File.separator;
                }
                MYLOG_PATH_SDCARD_DIR = baseFilePath;
            }
            Log.d((String)"LogTestTag", (String)("the target directory is:" + MYLOG_PATH_SDCARD_DIR));
            File file = new File(MYLOG_PATH_SDCARD_DIR);
            if (!file.exists()) {
                file.mkdirs();
            }
            return true;
        }
        return false;
    }

    private static void writeLogtoFile(String mylogtype, String tag, String text) {
        Date nowtime = new Date();
        String needWriteFiel = logfile.format(nowtime);
        String needWriteMessage = MYLOGSDF.format(nowtime) + "    " + mylogtype + "    " + tag + "    " + text;
        File file = new File(MYLOG_PATH_SDCARD_DIR, needWriteFiel + MYLOGFILEName);
        try {
            FileWriter filerWriter = new FileWriter(file, true);
            BufferedWriter bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(needWriteMessage);
            bufWriter.newLine();
            bufWriter.close();
            filerWriter.close();
        }
        catch (IOException e) {
            Log.e((String)tag, (String)e.getMessage());
        }
    }

    public static void delFile() {
        String needDelFiel = logfile.format(MyLogUtil.getDateBefore());
        File file = new File(MYLOG_PATH_SDCARD_DIR, needDelFiel + MYLOGFILEName);
        if (file.exists()) {
            file.delete();
        }
    }

    private static Date getDateBefore() {
        Date nowtime = new Date();
        Calendar now = Calendar.getInstance();
        now.setTime(nowtime);
        now.set(5, now.get(5) - 0);
        return now.getTime();
    }

    private static void executeLogTask(final Tasker tasker) {
        MyConveyor.getInstance().execute(new TaskRequest(){

            public TaskType getTaskType() {
                return TaskType.TASK_LOG;
            }

            public Tasker getTask() {
                return tasker;
            }
        });
    }

    static {
        MYLOG_SWITCH = true;
        MYLOG_WRITE_TO_FILE = true;
        MYLOGSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logfile = new SimpleDateFormat("yyyy-MM-dd");
    }
}

