/*
 * Decompiled with CFR 0.152.
 */
package com.happy3w.math.combination;

import com.happy3w.java.ext.ListUtils;
import com.happy3w.java.ext.Pair;
import com.happy3w.math.combination.DimCombineDetail;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DimCombinationMaker<K, V> {
    private List<Pair<K, List<V>>> dimensions = new ArrayList<Pair<K, List<V>>>();
    private boolean withNullDimension = false;
    private boolean withOverRelation = false;
    private final Map<String, Integer> weightMaskMap = new HashMap<String, Integer>();

    private void initWeightMask() {
        int weightMask = 1;
        for (Pair<K, List<V>> dimension : this.dimensions) {
            for (Object value : (List)dimension.getValue()) {
                String key = this.genWeightMaskKey(dimension.getKey(), value);
                this.weightMaskMap.put(key, weightMask);
                weightMask <<= 1;
            }
        }
    }

    private String genWeightMaskKey(K dimensionName, V dimensionValue) {
        return MessageFormat.format("{0}-{1}", dimensionName, dimensionValue);
    }

    public Stream<DimCombineDetail<K, V>> generateDetail() {
        Stream<DimCombineDetail<K, V>> detailStream = this.generateNormal().map(r -> new DimCombineDetail(r));
        if (this.withOverRelation) {
            return this.initOverRelation(detailStream);
        }
        return detailStream;
    }

    public Stream<List<Pair<K, V>>> generateNormal() {
        List<Pair<K, List<V>>> dimensions = this.mayBeNullDimensions(this.dimensions, this.withNullDimension);
        return StreamSupport.stream(CombineSpliterator.of(dimensions), false);
    }

    public Stream<List<V>> generateSimple() {
        return this.generateNormal().map(r -> ListUtils.map((Iterable)r, Pair::getValue));
    }

    private List<Pair<K, List<V>>> mayBeNullDimensions(List<Pair<K, List<V>>> dimensions, boolean withNullDimension) {
        if (withNullDimension) {
            return dimensions.stream().map(dimensionItem -> {
                ArrayList<Object> newDimValues = new ArrayList<Object>((Collection)dimensionItem.getValue());
                newDimValues.add(null);
                return new Pair(dimensionItem.getKey(), newDimValues);
            }).collect(Collectors.toList());
        }
        return dimensions;
    }

    private Stream<DimCombineDetail<K, V>> initOverRelation(Stream<DimCombineDetail<K, V>> detailStream) {
        List detailList = detailStream.peek(this::initScoreAndMask).collect(Collectors.toList());
        for (DimCombineDetail curDetail : detailList) {
            for (DimCombineDetail overedDetail : detailList) {
                if (!curDetail.isOver(overedDetail)) continue;
                curDetail.addOveredCombine(overedDetail);
            }
        }
        return detailList.stream();
    }

    public void initScoreAndMask(DimCombineDetail<K, V> dimCombineDetail) {
        int mask = 0;
        int score = 0;
        for (Pair<K, V> dimensionValue : dimCombineDetail.getNormalResult()) {
            if (dimensionValue.getValue() == null) continue;
            String weightMaskKey = this.genWeightMaskKey(dimensionValue.getKey(), dimensionValue.getValue());
            mask |= this.weightMaskMap.get(weightMaskKey).intValue();
            ++score;
        }
        dimCombineDetail.setScore(score);
        dimCombineDetail.setMask(mask);
    }

    public static <K, V> CombinationGeneratorBuilder<K, V> builder() {
        return new CombinationGeneratorBuilder();
    }

    public List<Pair<K, List<V>>> getDimensions() {
        return this.dimensions;
    }

    public boolean isWithNullDimension() {
        return this.withNullDimension;
    }

    public boolean isWithOverRelation() {
        return this.withOverRelation;
    }

    public Map<String, Integer> getWeightMaskMap() {
        return this.weightMaskMap;
    }

    public void setDimensions(List<Pair<K, List<V>>> dimensions) {
        this.dimensions = dimensions;
    }

    public void setWithNullDimension(boolean withNullDimension) {
        this.withNullDimension = withNullDimension;
    }

    public void setWithOverRelation(boolean withOverRelation) {
        this.withOverRelation = withOverRelation;
    }

    public static class CombinationGeneratorBuilder<K, V> {
        private DimCombinationMaker<K, V> generator = new DimCombinationMaker();

        public CombinationGeneratorBuilder<K, V> dimension(K dimensionName, V ... values) {
            if (dimensionName == null) {
                throw new UnsupportedOperationException("dimensionName can not be null.");
            }
            ((DimCombinationMaker)this.generator).dimensions.add(Pair.ofList(dimensionName, (Object[])values));
            return this;
        }

        public CombinationGeneratorBuilder<K, V> dimensionList(K dimensionName, Collection<V> values) {
            if (dimensionName == null) {
                throw new UnsupportedOperationException("dimensionName can not be null.");
            }
            ((DimCombinationMaker)this.generator).dimensions.add(new Pair(dimensionName, new ArrayList<V>(values)));
            return this;
        }

        public CombinationGeneratorBuilder<K, V> dimensions(List<Pair<K, List<V>>> dimensions) {
            ((DimCombinationMaker)this.generator).dimensions.addAll(dimensions);
            return this;
        }

        public CombinationGeneratorBuilder<K, V> withNullDimension(boolean withNull) {
            ((DimCombinationMaker)this.generator).withNullDimension = withNull;
            return this;
        }

        public CombinationGeneratorBuilder<K, V> withOverRelation(boolean withOverRelation) {
            ((DimCombinationMaker)this.generator).withOverRelation = withOverRelation;
            return this;
        }

        public DimCombinationMaker<K, V> build() {
            ((DimCombinationMaker)this.generator).initWeightMask();
            return this.generator;
        }
    }

    private static class CombineSpliterator<K, V>
    extends Spliterators.AbstractSpliterator<List<Pair<K, V>>> {
        private List<Pair<K, List<V>>> dimensions;
        private int currentIndex = 0;

        protected CombineSpliterator(List<Pair<K, List<V>>> dimensions, long est) {
            super(est, 64);
            this.dimensions = dimensions;
        }

        @Override
        public boolean tryAdvance(Consumer<? super List<Pair<K, V>>> action) {
            if ((long)this.currentIndex >= this.estimateSize()) {
                return false;
            }
            List<Pair<K, V>> currentDimension = this.createDimension(this.currentIndex);
            action.accept(currentDimension);
            ++this.currentIndex;
            return true;
        }

        private List<Pair<K, V>> createDimension(int currentIndex) {
            ArrayList<Pair<K, V>> dimensionValueList = new ArrayList<Pair<K, V>>();
            int dimensionValue = currentIndex;
            for (Pair<K, List<V>> dimDef : this.dimensions) {
                int index = dimensionValue % ((List)dimDef.getValue()).size();
                Pair newItem = new Pair(dimDef.getKey(), ((List)dimDef.getValue()).get(index));
                dimensionValueList.add(newItem);
                dimensionValue /= ((List)dimDef.getValue()).size();
            }
            return dimensionValueList;
        }

        public static <K, V> CombineSpliterator<K, V> of(List<Pair<K, List<V>>> dimensions) {
            int maxSize = CombineSpliterator.calculateMaxSize(dimensions);
            return new CombineSpliterator<K, V>(dimensions, (long)maxSize);
        }

        private static <V, K> int calculateMaxSize(List<Pair<K, List<V>>> dimensions) {
            int size = 1;
            for (Pair<K, List<V>> dimension : dimensions) {
                size *= ((List)dimension.getValue()).size();
            }
            return size;
        }
    }
}

